#include "stdafx.h"

#include "container.h"

namespace {

size_t s_nElementEntries;
MG::Element* s_elementPtrs[128];

} // anonymous namespace

namespace MG {

Container::Container(size_t nMaxEvents, size_t nMaxChildren)
	:
	Element(nMaxEvents)
{
	elements_.buff_ = &s_elementPtrs[s_nElementEntries];
	elements_.maxLength_ = nMaxChildren;
	s_nElementEntries += nMaxChildren;
	assert(s_nElementEntries < countof(s_elementPtrs));
}

Container::~Container()
{
}

void Container::AddChild(Element& e)
{
	elements_.push_back(&e);
	e.SetParent(this);
}

void Container::RemoveChild(Element& e)
{
	for (size_t i=0; i<elements_.length_; ++i) {
		if (elements_[i] == &e) {
			elements_[i] = 0;
			e.SetParent(0);
			break;
		}
	}
}

void Container::Draw(int16_t offsetX, int16_t offsetY, IRenderer& renderer)
{
	if (needsToDraw_) {
		__super::Draw(offsetX, offsetY, renderer);
		needsToDraw_ = false;
	}
	
	int16_t x = rect_.x + offsetX;
	int16_t y = rect_.y + offsetY;
	for (size_t i=0; i<elements_.length_; ++i) {
		Element* e = elements_[i];
		if (e && e->needsToDraw_) {
			e->Draw(x, y, renderer);
			e->needsToDraw_ = false;
		}
	}
}

bool Container::HitTest(int16_t x, int16_t y) const
{
	return true;
}

static
Element* hitTestElements(varray<Element*>& elements, int16_t x, int16_t y)
{
	const size_t len = elements.length_;
	for (size_t i=0; i<len; ++i) {
		Element* e = elements[i];
		if (e) {
			if (e->HitTest(x, y)) {
				return e;
			}
		}
	}
	return 0;
}

void Container::OnMouseDown(int16_t x, int16_t y)
{
	int16_t ox = x - rect_.x;
	int16_t oy = y - rect_.y;

	if (s_pCapture_) {
		s_pCapture_->OnMouseDown(ox, oy);
	}else {
		Element* e = hitTestElements(elements_, x, y);
		if (e) {
			e->OnMouseDown(ox, oy);
			return;
		}
	}
}

void Container::OnMouseUp(int16_t x, int16_t y)
{
	int16_t ox = x - rect_.x;
	int16_t oy = y - rect_.y;
	if (s_pCapture_) {
		s_pCapture_->OnMouseUp(ox, oy);
	}else {
		Element* e = hitTestElements(elements_, x, y);
		if (e) {
			e->OnMouseUp(ox, oy);
			return;
		}
	}
}

void Container::OnMouseMove(int16_t x, int16_t y)
{
	int16_t ox = x - rect_.x;
	int16_t oy = y - rect_.y;
	if (s_pCapture_) {
		s_pCapture_->OnMouseMove(ox, oy);
	}else {
		Element* e = hitTestElements(elements_, x, y);
		if (e) {
			e->OnMouseMove(ox, oy);
			return;
		}
	}
}

} // namespace MG

