#pragma once

#include "rectangle.h"

namespace MG {

struct Bitmap
{
	uint16_t width;
	uint16_t height;
	uint8_t bitsPerPixel;
	int lineOffsetBytes;
	void* pBits;
	
	Rectangle GetRect() const;	
};

struct Image
{
	Image()
		:
		pBitmap(0)
	{
	}
	
	Bitmap* pBitmap;
	Rectangle rect;
	
	Rectangle GetRect() const
	{
		if (pBitmap) {
			return Rectangle::Intersect(pBitmap->GetRect(), rect);
		}else {
			return rect;
		}
	}
};

Rectangle BitBlt(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
);

} // namespace MG

