#include "stdafx.h"

#include "bitmap.h"
#include "arrayutil.h"

namespace {

// http://www.virtualdub.org/blog/pivot/entry.php?id=117
__forceinline
void blendColor_Phaeron(uint32_t fc, uint8_t fca, uint32_t& bc)
{
	uint32_t bc2 = bc;
	uint32_t srb = fc & 0xff00ff;
	uint32_t sg = fc & 0x00ff00;
	uint32_t drb = bc2 & 0xff00ff;
	uint32_t dg = bc2 & 0x00ff00;
	uint32_t alpha = fca;
	alpha += (alpha > 0);
	uint32_t orb = (drb + (((srb - drb) * alpha + 0x800080) >> 8)) & 0xff00ff;
	uint32_t og = (dg + (((sg - dg ) * alpha + 0x008000) >> 8)) & 0x00ff00;
	
	bc = orb+og;
}

} // namespace anonymous

namespace MG {

Rectangle Bitmap::GetRect() const
{
	Rectangle ret;
	ret.x = 0;
	ret.y = 0;
	ret.w = width;
	ret.h = height;
	return ret;
}

void BitBlt_Src8_Dst24(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
}

void BitBlt_Src8_Dst32(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
}

void BitBlt_Src24_Dst24(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
	const uint8_t* pSrc = (const uint8_t*) src.pBits;
	OffsetPtr(pSrc, src.lineOffsetBytes * srcRect.y);
	pSrc += 3 * srcRect.x;
	
	uint8_t* pDst = (uint8_t*) dst.pBits;
	OffsetPtr(pDst, dst.lineOffsetBytes * dstRect.y);
	pDst += 3 * dstRect.x;
	
	for (size_t y=0; y<dstRect.h; ++y) {
		for (size_t x=0; x<dstRect.w * 3; ++x) {
			pDst[x] = pSrc[x];
		}
		OffsetPtr(pSrc, src.lineOffsetBytes);
		OffsetPtr(pDst, dst.lineOffsetBytes);
	}
}

void BitBlt_Src24_Dst32(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
}

void BitBlt_Src32_Dst24(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
	const uint32_t* pSrc = (const uint32_t*) src.pBits;
	OffsetPtr(pSrc, src.lineOffsetBytes * srcRect.y);
	pSrc += srcRect.x;
	
	uint8_t* pDst = (uint8_t*) dst.pBits;
	OffsetPtr(pDst, dst.lineOffsetBytes * dstRect.y);
	pDst += 3 * dstRect.x;
	
	for (size_t y=0; y<dstRect.h; ++y) {
		for (size_t x=0; x<dstRect.w; ++x) {
			uint32_t fc = pSrc[x];
			uint8_t fca = fc >> 24;
			uint32_t bc = (pDst[x*3+0] << 0) | (pDst[x*3+1] << 8) | (pDst[x*3+2] << 16);
			blendColor_Phaeron(fc, fca, bc);
			pDst[x*3+0] = (bc >> 0) & 0xff;
			pDst[x*3+1] = (bc >> 8) & 0xff;
			pDst[x*3+2] = (bc >> 16) & 0xff;
		}
		OffsetPtr(pSrc, src.lineOffsetBytes);
		OffsetPtr(pDst, dst.lineOffsetBytes);
	}
}

void BitBlt_Src32_Dst32(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
}

Rectangle BitBlt(
	const Bitmap& src, const Rectangle& srcRect,
	Bitmap& dst, const Rectangle& dstRect
	)
{
	Rectangle ret;
	Rectangle sbr = src.GetRect();
	sbr.Intersect(srcRect);
	
	Rectangle dbr = dst.GetRect();
	dbr.Intersect(dstRect);
	
	Rectangle sbr2 = sbr;
	sbr2.x = dbr.x;
	sbr2.y = dbr.y;
	dbr.Intersect(sbr2);
	
	assert(dst.bitsPerPixel == 24 || dst.bitsPerPixel == 32);
	switch (src.bitsPerPixel) {
	case 8:
		switch (dst.bitsPerPixel) {
		case 24:
			BitBlt_Src8_Dst24(src, sbr, dst, dbr);
			break;
		case 32:
			BitBlt_Src8_Dst32(src, sbr, dst, dbr);
			break;
		}
		break;
	case 24:
		switch (dst.bitsPerPixel) {
		case 24:
			BitBlt_Src24_Dst24(src, sbr, dst, dbr);
			break;
		case 32:
			BitBlt_Src24_Dst32(src, sbr, dst, dbr);
			break;
		}
		break;
	case 32:
		switch (dst.bitsPerPixel) {
		case 24:
			BitBlt_Src32_Dst24(src, sbr, dst, dbr);
			break;
		case 32:
			BitBlt_Src32_Dst32(src, sbr, dst, dbr);
			break;
		}
		break;
	}
	
	return dbr;
}


} // namespace MG
