﻿Namespace Framework


    ' NightStateクラスです。
    Public Class NightState
        Implements IState

        Private Shared _singleton As NightState = New NightState()

        ' コンストラクタです。(外部からのアクセス不可)
        Private Sub New()

        End Sub

        ' 唯一のインスタンスを取得します。
        Public Shared Function GetInstance() As IState
            Return _singleton
        End Function

        ' 時刻を設定します。
        Public Sub DoClock(ByVal context As IContext, ByVal hour As Integer) Implements IState.DoClock
            If (9 <= hour AndAlso hour < 17) Then
                context.ChageState(DayState.GetInstance)
            End If
        End Sub

        ' 金庫を使用します。
        Public Sub DoUse(ByVal context As IContext) Implements IState.DoUse
            context.CallSecurityCenter("非常: 夜間の金庫使用!!!")
        End Sub

        ' 非常ベルを鳴らします。
        Public Sub DoAlarm(ByVal context As IContext) Implements IState.DoAlarm
            context.CallSecurityCenter("非常ベル(夜間)")
        End Sub

        ' 通常の通話を行います。
        Public Sub DoPhone(ByVal context As IContext) Implements IState.DoPhone
            context.RecordLog("夜間の通話録音")
        End Sub

        ' NightStateの文字列表現を返します。
        Public Overrides Function ToString() As String
            Return "[夜間]"
        End Function

    End Class

End Namespace