﻿Imports System.IO, com
Imports iTextSharp.text.pdf
Imports iTextSharp.text
Imports WindowsApp1


Public Class Form1

    Private Class Form1Logger
        Inherits LoggerTemplate
        Private form As Form1
        Public Sub New(form As Form1)
            Me.form = form
        End Sub
        Public Overrides Sub output(message As String)
            form.lstLog.Items.Add(message)
        End Sub
    End Class
    Private log As Logger = New Form1Logger(Me)


    Private Sub btnExecute_Click(sender As Object, e As EventArgs) Handles btnExecute.Click
        log.Info("処理開始")
        Dim allPath = TextBox1.Text '全冊フォルダ
        '全冊フォルダのzipファイルを列挙するし以下を繰り返す。
        Dim files As String() = System.IO.Directory.GetFiles(allPath, "*.zip", System.IO.SearchOption.AllDirectories)
        For Each zipFilePath In files
            log.Info(zipFilePath)
            zipToPdf(zipFilePath)
        Next

        log.Info("処理終了")
    End Sub

    Private Sub zipToPdf(zipFilePath As String)
        '新規に解凍後の画像のフォルダを作成
        Using unzipSrcFiles As New AppTempDir(zipFilePath + ".temp1", log)
            '新規に分割後の画像のフォルダを作成
            Using divingFilesPath As New AppTempDir(zipFilePath + ".temp2", log)
                zipToPdf(zipFilePath, unzipSrcFiles, divingFilesPath)
            End Using
        End Using
    End Sub
    Dim filename_count = 1
    Private Sub SaveTo(ByVal image As Bitmap, ByVal temppath As String)
        Dim filepath = Path.Combine(temppath, String.Format("{0:D4}.jpg", filename_count))
        image.Save(filepath, Imaging.ImageFormat.Jpeg)
    End Sub


    Private Sub zipToPdf(zipFilePath As String, srcFiles As AppTempDir, tempFiles As AppTempDir)

        '解凍処理
        System.IO.Compression.ZipFile.ExtractToDirectory(zipFilePath, srcFiles.Path)
        Dim width As Integer
        Dim height As Integer
        filename_count = 1
        'tempフォルダのjpegファイルを列挙し以下を繰り返す
        Dim files As String() = System.IO.Directory.GetFiles(srcFiles.Path, "*.jpg", System.IO.SearchOption.AllDirectories)
        For Each filepath As String In files
            Dim filename = System.IO.Path.GetFileName(filepath)
            '先頭ファイルはそのままとする。001.jpg
            If filename.Contains("001") Then
                Dim image As New Bitmap(filepath)
                SaveTo(image, tempFiles.Path)
                '左側画像を保存する。
            Else
                Dim image As New Bitmap(filepath)
                width = image.Width / 2
                height = image.Height
                Dim desRect As New Drawing.Rectangle(0, 0, width, height)
                Dim destImage As New Bitmap(width, height)
                Dim g = Graphics.FromImage(destImage)
                '右側画像を保存する。
                Dim srcRect As New Drawing.Rectangle(width, 0, width, height)
                g.DrawImage(image, desRect, srcRect, GraphicsUnit.Pixel)
                SaveTo(destImage, tempFiles.Path)
                '左側画像を保存する。
                filename_count += 1
                Dim srcRect2 As New Drawing.Rectangle(0, 0, width, height)
                g.DrawImage(image, desRect, srcRect2, GraphicsUnit.Pixel)
                SaveTo(destImage, tempFiles.Path)
            End If
            filename_count += 1
        Next
        '２番目以降のファイルを読み込む。
        '2つに分割し右側をfilename_count.jpeg,左側をfilename_count+1.jpegとして保存する
        'tempフォルダをpdf化する
        'A4サイズを横向きで
        Dim psize As New iTextSharp.text.Rectangle(Width, Height)
        Dim pdfDocument = New Document(psize, 0, 0, 0, 0)
        '出力先のファイル名
        Dim makePdfFilePath = zipFilePath.Replace(".zip", "pdf")
        Dim fileStream = New FileStream(makePdfFilePath, FileMode.Create)
        Dim writer = PdfWriter.GetInstance(pdfDocument, fileStream)
        'PDFドキュメントを開く
        pdfDocument.Open()
        files = System.IO.Directory.GetFiles(tempFiles.Path, "*.jpg", System.IO.SearchOption.AllDirectories)
        For Each filepath As String In files
            Dim img = iTextSharp.text.Image.GetInstance(New Uri(filepath))
            pdfDocument.Add(img)
        Next
        'PDFドキュメントを閉じる
        pdfDocument.Close()

    End Sub


End Class
