﻿Imports System.IO


Public Class AppTempDir
    Implements IDisposable

    Public ReadOnly Property Path As String

    Private log As Logger

    Sub New(path As String, logger As Logger)
        Me.log = logger
        Me.Path = path
        Dim unzipSrcFilesPath = path
        IfExistDirDelete(unzipSrcFilesPath)
        Directory.CreateDirectory(unzipSrcFilesPath)
    End Sub

    Private Sub IDisposable_Dispose() Implements IDisposable.Dispose
        ' IfExistDirDelete(Path)
    End Sub

    ''' <summary>
    ''' もしディレクトリがあれば削除
    ''' </summary>
    ''' <param name="path"></param>
    Private Sub IfExistDirDelete(path As String)
        'tempフォルダを削除する。
        If Directory.Exists(path) Then
            Directory.Delete(path, True)
            log.Info(path + "を削除")
        End If
    End Sub
End Class
