﻿Public Class FormDispacher

    Private _secondScreen As Screen
    Public Sub SetSecondScreen(ByVal screen As Screen)
        _secondScreen = screen
        For Each frm In _secondMonitorWindows
            SetViewerBounds(frm)
        Next
    End Sub

    Private Sub SetViewerBounds(ByVal frm As Form)
        If _secondScreen Is Nothing Then
            Return
        End If
        Dim bouds = _secondScreen.Bounds
        frm.StartPosition = FormStartPosition.Manual
        frm.Location = bouds.Location
        frm.Size = bouds.Size
    End Sub

    Private _secondMonitorWindows As New List(Of Form)

    Private Sub registViewer(frm As Form)
        If Not _secondMonitorWindows.Contains(frm) Then
            _secondMonitorWindows.Add(frm)
        End If
        SetViewerBounds(frm)
    End Sub

    Private Shared instance As FormDispacher
    Public Shared Function GetInstance() As FormDispacher
        If instance Is Nothing Then
            instance = New FormDispacher
        End If
        Return instance
    End Function

    Private _frmOperation As frmOperation
    Public Sub ShowOperation()
        Create(_frmOperation, GetType(frmOperation))
        _frmOperation.Show()
    End Sub


    Public Sub ShowImage()
        Show(_frmImageViewer, GetType(frmImageViewer))
    End Sub
    Private _frmImageViewer As frmImageViewer
    Public Function GetPictureBox() As PictureBox
        If _frmImageViewer Is Nothing Then
            ShowImage()
        End If
        Return _frmImageViewer.PictureBox1
    End Function

    Dim _frmPdfViewer As frmPdfViewer

    Private _frmMovieViewer As frmMovieViewer
    Public Sub ShowMovie()
        Show(_frmMovieViewer, GetType(frmMovieViewer))
    End Sub
    Public Function GetPlayer() As AxWMPLib.AxWindowsMediaPlayer
        If _frmMovieViewer Is Nothing Then
            ShowMovie()
        End If
        Return _frmMovieViewer.AxWindowsMediaPlayer1
    End Function

    Public Sub Create(ByRef form As Form, ByVal formType As Type)
        If form Is Nothing Then
            form = Activator.CreateInstance(formType)
        End If

    End Sub

    Private Sub HideOther(ByVal targetForm As Form)
        For Each frm In _secondMonitorWindows
            If frm Is targetForm Then
                Continue For
            End If
            frm.Hide()
        Next
    End Sub

    Public Sub Show(ByRef targetForm As Form, ByVal formType As Type)
        Create(targetForm, formType)
        registViewer(targetForm)
        HideOther(targetForm)
        targetForm.Show()
    End Sub

    Public Sub HidePdfViewer()
        _frmPdfViewer.Hide()
    End Sub

    Public Sub ShowPdfViewer()
        Show(_frmPdfViewer, GetType(frmPdfViewer))
    End Sub

    'Private _frmStartup As frmStartup
    'Public Sub SetStartup(ByVal frm As frmStartup)
    '    _frmStartup = frmStartup
    'End Sub
    Public Sub Close()
        '特に処理なし
    End Sub

    Public Function GetFrmPdfViewer() As frmPdfViewer
        Return _frmPdfViewer
    End Function


End Class
