﻿Public Class FormDispacher

    Private _secondScreen As Screen
    Public Sub SetSecondScreen(ByVal screen As Screen)
        _secondScreen = screen
        For Each frm In _secondMonitorWindows
            SetViewerBounds(frm)
        Next
    End Sub

    Private Sub SetViewerBounds(ByVal frm As Form)
        If _secondScreen Is Nothing Then
            Return
        End If
        Dim bouds = _secondScreen.Bounds
        frm.StartPosition = FormStartPosition.Manual
        frm.Location = bouds.Location
        frm.Size = bouds.Size
    End Sub

    Private _secondMonitorWindows As New List(Of Form)

    Private Sub registViewer(frm As Form)
        _secondMonitorWindows.Add(frm)
        SetViewerBounds(frm)
    End Sub

    Private Shared instance As FormDispacher
    Public Shared Function GetInstance() As FormDispacher
        If instance Is Nothing Then
            instance = New FormDispacher
        End If
        Return instance
    End Function

    Private _frmOperation As frmOperation
    Public Sub ShowOperation()
        If _frmOperation Is Nothing Then
            _frmOperation = New frmOperation
        End If
        _frmOperation.Show()
    End Sub
    Public Function GetAxPDF() As AxAcroPDFLib.AxAcroPDF

        Return _frmPdfViewer.AxAcroPDF1

    End Function

    Public Sub ShowImage()
        If _frmImageViewer Is Nothing Then
            _frmImageViewer = New frmImageViewer
            registViewer(_frmImageViewer)
        End If
        _frmImageViewer.Show()
    End Sub
    Private _frmImageViewer As frmImageViewer
    Public Function GetPictureBox() As PictureBox
        If _frmImageViewer Is Nothing Then
            ShowImage()
        End If
        Return _frmImageViewer.PictureBox1
    End Function

    Dim _frmPdfViewer As frmPdfViewer

    Private _frmMovieViewer As frmMovieViewer
    Public Sub ShowMovie()
        If _frmMovieViewer Is Nothing Then
            _frmMovieViewer = New frmMovieViewer
            registViewer(_frmMovieViewer)
        End If
        _frmMovieViewer.Show()
    End Sub
    Public Function GetPlayer() As AxWMPLib.AxWindowsMediaPlayer
        If _frmMovieViewer Is Nothing Then
            ShowMovie()
        End If
        Return _frmMovieViewer.AxWindowsMediaPlayer1
    End Function


    Public Sub HidePdfViewer()
        _frmPdfViewer.Hide()
    End Sub

    Public Sub ShowPdfViewer()
        If _frmPdfViewer Is Nothing Then
            _frmPdfViewer = New frmPdfViewer
            registViewer(_frmPdfViewer)
        End If
        _frmPdfViewer.Show()

    End Sub

    Private _frmStartup As frmStartup
    Public Sub SetStartup(ByVal frm As frmStartup)
        _frmStartup = frmStartup
    End Sub
    Public Sub Close()
        _frmPdfViewer.Close()
        _frmStartup.Close()
    End Sub

    Public Sub frmPdfViewHideNavi()
        _frmPdfViewer.Activate()
        Threading.Thread.Sleep(100)
        SendKeys.Send("+{F4}")
    End Sub

End Class
