﻿Imports System.Windows.Forms



Public Class frmOperation

#Region "初期処理"

    Public Property frmView As frmView
    Public Property axPDF As AxAcroPDFLib.AxAcroPDF

    Private Sub frmOperation_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        screenDetect()
        AppSettingLoad()
        ActivateForm()
    End Sub

    Private Sub ActivateForm()

        Timer1.Interval = 100
        Timer1.Start()
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        Me.Activate()
        Timer1.Stop()
    End Sub

#Region "設定値"
    Private loading As Boolean
    Private Sub AppSettingLoad()
        loading = True
        nudHeight.Value = My.Settings.nudHeight
        nudWidth.Value = My.Settings.nudWidth
        cmbDisplay.SelectedIndex = My.Settings.cmbDisplaySelectedIndex
        cmbPDFView.SelectedIndex = My.Settings.cmbView
        nudPdfZoom.Value = My.Settings.nupPDFZoom
        Try
            Dim fvinfos As New List(Of fileviewInfo)

            'XmlSerializerオブジェクトを作成
            Dim serializer As New System.Xml.Serialization.XmlSerializer(
                GetType(List(Of fileviewInfo)))
            '読み込むファイルを開く
            Using sr As New System.IO.StreamReader(
                "lstPDFFiles.xml", New System.Text.UTF8Encoding(False))
                'XMLファイルから読み込み、逆シリアル化する
                fvinfos =
                DirectCast(serializer.Deserialize(sr), List(Of fileviewInfo))
                'ファイルを閉じる
            End Using
            For Each info In fvinfos
                lstPDFFiles.Items.Add(info)
            Next
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
        loading = False
    End Sub

    Private Sub AppSettingSave()

        My.Settings.cmbDisplaySelectedIndex = cmbDisplay.SelectedIndex
        My.Settings.cmbView = cmbPDFView.SelectedIndex
        My.Settings.nupPDFZoom = nudPdfZoom.Value
        My.Settings.nudHeight = nudHeight.Value
        My.Settings.nudWidth = nudWidth.Value
        My.Settings.Save()

        Dim fvinfos As New List(Of fileviewInfo)
        For Each info In lstPDFFiles.Items
            fvinfos.Add(info)
        Next
        Dim serializer As New System.Xml.Serialization.XmlSerializer(
            GetType(List(Of fileviewInfo)))
        '書き込むファイルを開く（UTF-8 BOM無し）
        Using sw As New System.IO.StreamWriter(
            "lstPDFFiles.xml", False, New System.Text.UTF8Encoding(False))
            'シリアル化し、XMLファイルに保存する
            serializer.Serialize(sw, fvinfos)
            'ファイルを閉じる
        End Using
    End Sub

#End Region

    Private Sub screenDetect()
        'デバイス名が表示されるようにする
        Me.cmbDisplay.DisplayMember = "DeviceName"
        Me.cmbDisplay.DataSource = Screen.AllScreens

    End Sub
#End Region

#Region "終了処理"

    Private Sub frmOperation_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        AppSettingSave()
        frmView.Close()
    End Sub
#End Region

#Region "フォームをセカンドディスプレイに表示"
    Private Sub cmbDisplay_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbDisplay.SelectedIndexChanged

        If cmbDisplay.SelectedIndex < 0 Then
            Exit Sub
        End If
        If cmbDisplay.SelectedItem Is Nothing Then
            Exit Sub
        End If
        '        'フォームを表示するディスプレイのScreenを取得する
        Dim s As Screen = DirectCast(Me.cmbDisplay.SelectedItem, Screen)
        '        'フォームの開始位置をディスプレイの左上座標に設定する
        frmView.StartPosition = FormStartPosition.Manual
        frmView.Location = s.Bounds.Location
        If Not loading OrElse nudHeight.Value = 0 Then
            nudHeight.Value = s.Bounds.Size.Height
            nudWidth.Value = s.Bounds.Size.Width
        End If

    End Sub





#End Region

#Region "Adobe PDF Reader の 処理"

#Region "ページ移動"

    Private Sub btnFirst_Click(sender As Object, e As EventArgs) Handles btnPDFFirst.Click
        axPDF.gotoFirstPage()
    End Sub

    Private Sub btnNext_Click(sender As Object, e As EventArgs) Handles btnPDFNext.Click
        axPDF.gotoNextPage()
    End Sub

    Private Sub btnBack_Click(sender As Object, e As EventArgs) Handles btnPDFBack.Click
        axPDF.gotoPreviousPage()
    End Sub

    Private Sub btnLast_Click(sender As Object, e As EventArgs) Handles btnPDFLast.Click
        axPDF.gotoLastPage()
    End Sub

#End Region

    ''' <summary>
    ''' ページのおさまり表示の変更
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub cmbView_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbPDFView.SelectedIndexChanged
        If axPDF Is Nothing Then
            Exit Sub
        End If
        axPDF.setView(cmbPDFView.Text)
    End Sub

    Private Sub nudPdfZoom_ValueChanged(sender As Object, e As EventArgs) Handles nudPdfZoom.ValueChanged
        If axPDF Is Nothing Then
            Exit Sub
        End If
        frmView.SetZoom(nudPdfZoom.Value)
        SetLstZoom(nudPdfZoom.Value)
    End Sub

    ''' <summary>
    ''' PDFを閉じる
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnFileClose_Click(sender As Object, e As EventArgs) Handles btnPDFFileClose.Click
        txtPDFFileName.Text = String.Empty
    End Sub



#Region "PDFファイルを開く"
    '    Private backFileName As String
    Private Sub btnFileOpen_Click(sender As Object, e As EventArgs) Handles btnOpenPDFFile.Click
        OpenFileDialog1.Filter = "PDFファイル (*.pdf) |*.pdf"
        OpenFileDialog1.FileName = txtPDFFileName.Text
        Dim ret = OpenFileDialog1.ShowDialog()
        If ret = Windows.Forms.DialogResult.Cancel Then
            Exit Sub
        End If

        txtPDFFileName.Text = OpenFileDialog1.FileName
        lstPDFFiles.SelectedItem = Nothing
    End Sub

    Private Sub txtFileName_TextChanged(sender As Object, e As EventArgs) Handles txtPDFFileName.TextChanged
        If txtPDFFileName.Text = String.Empty Then
            'ファイルを閉じることはできないので非表示にしている。
            frmView.pnlCover.Visible = True

            Return
        End If
        frmView.pnlCover.Visible = False
        'If backFileName = txtPDFFileName.Text Then
        '    Return
        'End If
        If Not BackgroundWorker1.IsBusy Then
            BackgroundWorker1.RunWorkerAsync()
        End If
    End Sub



#End Region
#End Region

#Region "Media Playerの処理"

    Private inPlay As Boolean = False
    Private Sub btnOpenMediaFile_Click(sender As Object, e As EventArgs) Handles btnOpenMediaFile.Click
        OpenFileDialog1.Filter = "映像ファイル (*.wmv;*.mp4)|*.wmv;*.mp4;|画像ファイル(*.jpg)|*.jpg|All Files(*.*)|*.*;"
        OpenFileDialog1.FileName = txtMediaFileName.Text
        Dim ret = OpenFileDialog1.ShowDialog()
        If ret = Windows.Forms.DialogResult.Cancel Then
            Exit Sub
        End If

        txtMediaFileName.Text = OpenFileDialog1.FileName
        SetVideo()

    End Sub

    Private Sub btnStartStop_Click(sender As Object, e As EventArgs) Handles btnStartStop.Click
        If Not inPlay Then
            PlayVideo()
        Else
            StopVideo()
        End If
    End Sub

    Sub SetVideo()
        frmView.UserControl11.SetFile(txtMediaFileName.Text)
    End Sub

    Sub PlayVideo()
        inPlay = True
        frmView.UserControl11.PlayVideo()
        btnStartStop.Text = "停止する"
    End Sub

    Sub StopVideo()
        inPlay = False
        frmView.UserControl11.StopVideo()
        btnStartStop.Text = "再生する"
    End Sub





#End Region

    Private Sub tbcFileOpes_SelectedIndexChanged(sender As Object, e As EventArgs) Handles tbcFileOpes.SelectedIndexChanged
        If tbcFileOpes.SelectedTab Is tpAdobePDF Then
            frmView.pnlCover.Visible = False
            frmView.UserControl11.Visibility = Windows.Visibility.Hidden
            StopVideo()
        Else
            frmView.pnlCover.Visible = True
            frmView.UserControl11.Visibility = Windows.Visibility.Visible
        End If

    End Sub

    Private Sub NumericUpDown1_ValueChanged(sender As Object, e As EventArgs) Handles nudHeight.ValueChanged
        frmView.Height = nudHeight.Value

    End Sub

    Private Sub NumericUpDown2_ValueChanged(sender As Object, e As EventArgs) Handles nudWidth.ValueChanged
        frmView.Width = nudWidth.Value
    End Sub



#Region "リストボックス処理"

    Private Sub btnInsert_Click(sender As Object, e As EventArgs) Handles btnInsert.Click
        Dim fileviewinfo As New fileviewInfo
        fileviewinfo.fileName = txtPDFFileName.Text
        fileviewinfo.zoom = nudPdfZoom.Value
        lstPDFFiles.Items.Add(fileviewinfo)

    End Sub

    Private Sub btnDelete_Click(sender As Object, e As EventArgs) Handles btnDelete.Click
        If lstPDFFiles.SelectedItem Is Nothing Then
            Exit Sub
        End If
        Dim fileviewinfo As fileviewInfo
        fileviewinfo = lstPDFFiles.SelectedItem
        lstPDFFiles.Items.Remove(fileviewinfo)
    End Sub



    Private Sub SetLstZoom(ByVal value As Decimal)
        Dim fileviewinfo As fileviewInfo
        fileviewinfo = lstPDFFiles.SelectedItem
        If fileviewinfo Is Nothing Then
            Exit Sub
        End If
        fileviewinfo.zoom = nudPdfZoom.Value
    End Sub

    Private Sub lstPDFFiles_Click(sender As Object, e As EventArgs) Handles lstPDFFiles.Click
        Dim fileviewinfo As fileviewInfo
        fileviewinfo = lstPDFFiles.SelectedItem
        If fileviewinfo Is Nothing Then
            Exit Sub
        End If
        txtPDFFileName.Text = fileviewinfo.fileName
        nudPdfZoom.Value = fileviewinfo.zoom
    End Sub



    Delegate Sub simpleDelegate()

    Private Sub BackgroundWorker1_DoWork(sender As Object, e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork

        Dim loadfuunc As simpleDelegate = AddressOf loadFile
        Me.Invoke(loadfuunc)
        Threading.Thread.Sleep(1)

        Dim func3 As simpleDelegate = AddressOf setzoom
        Me.Invoke(func3)
        Threading.Thread.Sleep(100)

        Dim loadfuunc2 As simpleDelegate = AddressOf Loadfile2
        Me.Invoke(loadfuunc2)
        Threading.Thread.Sleep(5000)

        Me.Invoke(func3)
        Threading.Thread.Sleep(100)

        Dim func As simpleDelegate = AddressOf hideToolBar
        Me.Invoke(func)
        Threading.Thread.Sleep(1000)

        Dim func2 As simpleDelegate = AddressOf hideScrollbars
        Me.Invoke(func2)
        Threading.Thread.Sleep(1000)


    End Sub

    Sub setzoom()
        frmView.SetZoom(nudPdfZoom.Value)
    End Sub

    Sub hideScrollbars()
        axPDF.setShowScrollbars(False)
    End Sub
    Sub loadFile()
        frmView.LoadFile(txtPDFFileName.Text)
    End Sub

    Sub Loadfile2()
        frmView.LoadFile(txtPDFFileName.Text)
        Threading.Thread.Sleep(500)
        frmView.Activate()
        SendKeys.Send("+{F4}")
    End Sub
    Sub hideToolBar()
        axPDF.setShowToolbar(False)
    End Sub

    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles btnNavigateHide.Click
        axPDF.setShowToolbar(False)
        frmView.Activate()
        SendKeys.Send("+{F4}")

    End Sub




#End Region

End Class