﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports doubutu.UI.Form



'''<summary>
'''KomaUtilTest のテスト クラスです。すべての
'''KomaUtilTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class KomaUtilTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''OppositeKoma のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub OppositeKomaTest()
        Assert.AreEqual(Koma.GoteHI, KomaUtil.OppositeKoma(Koma.SenteHI))
        Assert.AreEqual(Koma.GoteKI, KomaUtil.OppositeKoma(Koma.SenteKI))
        Assert.AreEqual(Koma.GoteLI, KomaUtil.OppositeKoma(Koma.SenteLI))
        Assert.AreEqual(Koma.GoteNI, KomaUtil.OppositeKoma(Koma.SenteNI))
        Assert.AreEqual(Koma.GoteZO, KomaUtil.OppositeKoma(Koma.SenteZO))
        Assert.AreEqual(Koma.SenteHI, KomaUtil.OppositeKoma(Koma.GoteHI))
        Assert.AreEqual(Koma.SenteKI, KomaUtil.OppositeKoma(Koma.GoteKI))
        Assert.AreEqual(Koma.SenteLI, KomaUtil.OppositeKoma(Koma.GoteLI))
        Assert.AreEqual(Koma.SenteNI, KomaUtil.OppositeKoma(Koma.GoteNI))
        Assert.AreEqual(Koma.SenteZO, KomaUtil.OppositeKoma(Koma.GoteZO))

    End Sub


    '''<summary>
    '''GetKomaFromCode のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub GetKomaFromCodeTest()

        Assert.AreEqual(Koma.GoteHI, KomaUtil.GetKomaFromCode("HI", Side.Gote))
        Assert.AreEqual(Koma.GoteNI, KomaUtil.GetKomaFromCode("NI", Side.Gote))
        Assert.AreEqual(Koma.SenteLI, KomaUtil.GetKomaFromCode("LI", Side.Sente))
        Assert.AreEqual(Koma.SenteKI, KomaUtil.GetKomaFromCode("KI", Side.Sente))
        Assert.AreEqual(Koma.GoteZO, KomaUtil.GetKomaFromCode("ZO", Side.Gote))

    End Sub

    '''<summary>
    '''ToCode のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub ToCodeTest()
        Assert.AreEqual("HI", KomaUtil.ToCode(Koma.GoteHI))
        Assert.AreEqual("LI", KomaUtil.ToCode(Koma.SenteLI))
        Assert.AreEqual(". ", KomaUtil.ToCode(Koma.Empty))
    End Sub
End Class
