﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports doubutu.UI.Form



'''<summary>
'''BoardTest のテスト クラスです。すべての
'''BoardTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class BoardTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''ToString のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub ToStringTest1()
        Dim target As Board = New Board() ' TODO: 適切な値に初期化してください
        Dim expected As String = "-KI-LI-ZO" & vbCrLf &
                                 " . -HI . " & vbCrLf &
                                 " . +HI . " & vbCrLf &
                                 "+ZO+LI+KI" & vbCrLf &
                                 "000000" & vbCrLf &
                                 "+" & vbCrLf
        Assert.AreEqual(expected, target.ToString)
    End Sub

    '''<summary>
    '''DoMove のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub DoMoveTest()
        Dim target As Board = New Board()
        Dim move As New Move("+B3B2HI")
        target.DoMove(move)
        Dim expected As String = "-KI-LI-ZO" & vbCrLf &
                               " . +HI . " & vbCrLf &
                               " .  .  . " & vbCrLf &
                               "+ZO+LI+KI" & vbCrLf &
                               "100000" & vbCrLf &
                               "-" & vbCrLf
        Assert.AreEqual(expected, target.ToString)
    End Sub

    <TestMethod()> _
    Public Sub ToStringTest2()
        Dim target As Board = New Board()
        Dim move1 As New Move("+B3B2HI")
        Dim move2 As New Move("-C1B2ZO")
        target.DoMove(move1)
        target.DoMove(move2)
        Assert.AreEqual(1, target.CapturedKomaCount(Koma.GoteHI))
        Dim expected As String = "-KI-LI . " & vbCrLf &
                               " . -ZO . " & vbCrLf &
                               " .  .  . " & vbCrLf &
                               "+ZO+LI+KI" & vbCrLf &
                               "100100" & vbCrLf &
                               "-" & vbCrLf
        Assert.AreEqual(expected, target.ToString)
    End Sub
    '''<summary>
    '''CapturedKomaCount のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub CapturedKomaCountTest()
        Dim target As Board = New Board()
        Dim move As New Move("+B3B2HI")
        target.DoMove(move)
        Assert.AreEqual(1, target.CapturedKomaCount(Koma.SenteHI))
        Assert.AreEqual(0, target.CapturedKomaCount(Koma.GoteHI))
        Assert.AreEqual(0, target.CapturedKomaCount(Koma.SenteZO))
        Assert.AreEqual(0, target.CapturedKomaCount(Koma.SenteKI))
    End Sub
End Class
