﻿Namespace Control.Board

    Public Class BoardViewer


        Public Event Editing(ByVal sender As System.Object, ByVal e As EditingEventArgs)

        Public Event Edited(ByVal sender As System.Object, ByVal e As EditedEventArgs)

        Private imageLoader As ImageLoader = imageLoader.GetInstance

        Dim _goteMochigoma() As Koma = {Koma.GoteHI, Koma.GoteZO, Koma.GoteKI}
        Dim _senteMochigoma() As Koma = {Koma.SenteHI, Koma.SenteZO, Koma.SenteKI}

        Private _kyokumen As New doubutu.UI.Form.Board
        Public Property kyokumen As doubutu.UI.Form.Board
            Get
                Return _kyokumen
            End Get
            Set(value As doubutu.UI.Form.Board)
                If value Is Nothing Then
                    _kyokumen = New doubutu.UI.Form.Board
                Else
                    _kyokumen = New doubutu.UI.Form.Board(value)
                End If
            End Set
        End Property

        Public Sub Initialize()
            imageLoader.Load()
            MakeBaseBitmap()
        End Sub

        Private _baseBitmap As Bitmap
        Private _currentBitmap As Bitmap
        Private _movingBackBitmap As Bitmap
        Private _movingKomaBitmap As Bitmap

        Private _isBoardViewRotated As Boolean
        Public Property IsBoardViewRotated As Boolean
            Get
                Return _isBoardViewRotated
            End Get
            Set(value As Boolean)
                _isBoardViewRotated = value
                imageLoader.SetBoardBiewRotated(_isBoardViewRotated)
            End Set
        End Property


        Private moveKomaInfo As New MoveKomaInfo




        Public Sub MakeBaseBitmap()

            _movingBackBitmap = New Bitmap(Me.Width, Me.Height)
            _baseBitmap = New Bitmap(Me.Width, Me.Height)

            Dim graphics As Graphics = graphics.FromImage(_baseBitmap)
            Dim srcRect As Rectangle = New Rectangle(0, 0, goteKomadaiRect.Width, goteKomadaiRect.Height)
            Dim srcRect2 As Rectangle = New Rectangle(0, 0, imageLoader.BoardBitmap.Width, imageLoader.BoardBitmap.Height)
            graphics.DrawImage(imageLoader.BoardBitmap, goteKomadaiRect, srcRect, GraphicsUnit.Pixel)
            graphics.DrawImage(imageLoader.BoardBitmap, senteKomadaiRect, srcRect, GraphicsUnit.Pixel)
            graphics.DrawImage(imageLoader.BoardBitmap, boardRect, srcRect2, GraphicsUnit.Pixel)
            Dim masuBitmap As Bitmap = imageLoader.MasuBitmap
            graphics.DrawImage(masuBitmap, boardRect, srcRect2, GraphicsUnit.Pixel)
            graphics.Dispose()
        End Sub

        Public Sub DrawCurrentBitmap()
            _currentBitmap = New Bitmap(Me.Width, Me.Height)
            Dim graphics As Graphics = graphics.FromImage(_currentBitmap)
            Dim rect As Rectangle = New Rectangle(0, 0, Me.Width, Me.Height)
            graphics.DrawImage(_baseBitmap, rect)

            For row As Byte = 1 To Form.Board.SIZE_Y
                For col As Byte = 1 To Form.Board.SIZE_X
                    Dim koma As Koma = kyokumen.GetCells(col, row)
                    If Not koma = Form.Koma.Empty Then
                        Dim masuRect As Rectangle = GetMasuRect(col, row)
                        graphics.DrawImage(imageLoader.GetKomaImage(koma), masuRect)
                    End If
                Next
            Next


            '持ち駒を表示する。
            For i As Integer = 0 To _senteMochigoma.Count - 1
                Dim KomaCount As Integer = kyokumen.CapturedKomaCount(_senteMochigoma(i))
                If KomaCount > 0 Then
                    DrawMochigoma(graphics, _senteMochigoma(i), KomaCount)
                End If
            Next

            For i As Integer = 0 To _goteMochigoma.Count - 1
                Dim KomaCount As Integer = kyokumen.CapturedKomaCount(_goteMochigoma(i))
                If KomaCount > 0 Then
                    DrawMochigoma(graphics, _goteMochigoma(i), KomaCount)
                End If
            Next


            Me.Invalidate()
        End Sub




        Private Sub DrawMochigoma(graphics As Graphics, komaValue As Koma, komaCount As Integer)
            Debug.Assert(0 <= komaCount)
            Dim mochigomaRect As Rectangle = Me.GetMochigomaRect(komaValue)
            Dim stringRect As Rectangle = New Rectangle(mochigomaRect.Right, mochigomaRect.Top, 28, mochigomaRect.Height)

            DrawMochigomaKomabakoImage(graphics, mochigomaRect, stringRect, GetStringMochigomaFormat, komaValue, komaCount)
        End Sub

        Private Sub DrawMochigomaKomabakoImage(graphics As Graphics,
                                               mochigomaRect As Rectangle,
                                               stringRect As Rectangle,
                                                stringFormat As StringFormat,
                                                komaValue As Koma, KomaCount As Integer)
            Dim font As Font = GetFont()
            Dim allRect As Rectangle = Rectangle.Union(mochigomaRect, stringRect)
            graphics.DrawImage(_baseBitmap, allRect, allRect, GraphicsUnit.Pixel)
            Dim image As Bitmap = imageLoader.GetKomaImage(komaValue)
            graphics.DrawImage(image, mochigomaRect)
            graphics.DrawString(String.Format("{0}", KomaCount), font, Brushes.Black, stringRect, stringFormat)
        End Sub

        Private Function GetFont() As Font
            Return New Font("Arial", 14.0F)
        End Function

        Private Function GetStringMochigomaFormat() As StringFormat
            Dim sf As New StringFormat()
            sf.Alignment = StringAlignment.Far
            sf.LineAlignment = StringAlignment.Center
            Return sf
        End Function

        Private Function GetStringKomabakoFormat() As StringFormat
            Dim sf As New StringFormat()
            sf.Alignment = StringAlignment.Center
            sf.LineAlignment = StringAlignment.Center
            Return sf
        End Function

        Private ReadOnly Property boardRect() As Rectangle
            Get
                Return New Rectangle(goteKomadaiRect.Right + 10, 3, imageLoader.BoardBitmap.Width, imageLoader.BoardBitmap.Height)
            End Get
        End Property

        Private ReadOnly Property goteKomadaiRect() As Rectangle
            Get
                Return New Rectangle(3, 3, KomadaiSize.Width, KomadaiSize.Height)
            End Get
        End Property

        Private ReadOnly Property senteKomadaiRect() As Rectangle
            Get
                Return New Rectangle(boardRect.Right + 10, boardRect.Bottom - KomadaiSize.Height, KomadaiSize.Width, KomadaiSize.Height)
            End Get
        End Property

        Private ReadOnly Property KomadaiSize As Size
            Get
                Return New Size(komaSize.Width + 28, komaSize.Height * 3 + 11)
            End Get
        End Property

        Public ReadOnly Property komaSize() As Size
            Get
                Return New Size(imageLoader.HighLightBitmap.Width + 5, imageLoader.HighLightBitmap.Height + 5)
            End Get
        End Property


        Private Function GetMochigomaRect(komaValue As Koma) As Rectangle
            Dim rect As Rectangle = Rectangle.Empty
            Dim isGote As Boolean = KomaUtil.IsGote(komaValue)
            Dim idx As Integer = -1
            If isGote Then
                For i As Integer = 0 To _goteMochigoma.Count - 1
                    If _goteMochigoma(i) = komaValue Then
                        idx = i
                        Exit For
                    End If
                Next
            Else
                For i As Integer = 0 To _senteMochigoma.Count - 1
                    If _senteMochigoma(i) = komaValue Then
                        idx = i
                        Exit For
                    End If
                Next
            End If
            If (isGote AndAlso Not IsBoardViewRotated) OrElse
             (Not isGote AndAlso IsBoardViewRotated) Then
                rect = New Rectangle(goteKomadaiRect.Left, goteKomadaiRect.Top + 11 + komaSize.Height * (idx), komaSize.Width, komaSize.Height)
            Else
                rect = New Rectangle(senteKomadaiRect.Left, senteKomadaiRect.Top + komaSize.Height * (idx), komaSize.Width, komaSize.Height)
            End If

            Return rect
        End Function


        Public Function GetMasuRect(l As Position) As Rectangle
            Return GetMasuRect(l.X, l.Y)
        End Function

        Const SIZE_X = UI.Form.Board.SIZE_X
        Const SIZE_Y = UI.Form.Board.SIZE_Y

        Private Function GetMasuRect(col As Integer, row As Integer) As Rectangle
            Debug.Assert(1 <= row AndAlso row <= SIZE_Y)
            Debug.Assert(1 <= col AndAlso col <= SIZE_X)
            Dim masuRect As Rectangle = Rectangle.Empty

            If IsBoardViewRotated Then
                row = SIZE_Y - (row - 1)
                col = SIZE_X - (col - 1)
                Debug.Assert(1 <= row AndAlso row <= SIZE_Y)
                Debug.Assert(1 <= col AndAlso col <= SIZE_X)
            End If
            Return New Rectangle(boardRect.Left + 28 + komaSize.Width * (col - 1), boardRect.Top + 36 + komaSize.Height * (row - 1), komaSize.Width, komaSize.Height)

            Return masuRect
        End Function

        ''' <summary>
        ''' 行先を取得する。
        ''' </summary>
        ''' <param name="p">マウスを押した場所</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Private Function GetToLocationAndMovingKoma(ByVal p As Point) As Position
            Dim movingKomaValue As koma = moveKomaInfo.MovingKoma
            If Not Me.moveKomaInfo.IsValidPosition Then
                Return Nothing
            End If
            Dim tolocation As Position

            If boardRect.Contains(p) Then
                tolocation = Me.GetKomaPosition(p)
                If tolocation = moveKomaInfo.From Then
                    Return Nothing
                End If
            ElseIf goteKomadaiRect.Contains(p) Then
                tolocation = Position.Captured
                movingKomaValue = KomaUtil.KomaKind(KomaUtil.CaputringKoma(moveKomaInfo.MovingKoma)) + Koma.Gote
                If goteKomadaiRect.Contains(moveKomaInfo.MouseDownPt) Then
                    Return Nothing
                End If
            ElseIf senteKomadaiRect.Contains(p) Then
                tolocation = Position.Captured
                movingKomaValue = KomaUtil.KomaKind(KomaUtil.CaputringKoma(moveKomaInfo.MovingKoma)) + Koma.Sente
                If senteKomadaiRect.Contains(moveKomaInfo.MouseDownPt) Then
                    Return Nothing
                End If
            Else
                Return Nothing
            End If
            If tolocation.IsCaptured Then
                If KomaUtil.KomaKind(movingKomaValue) = Koma.LI Then
                    Return Nothing
                End If
            End If

            If tolocation.IsInCell Then
                Dim capturedKoma As Koma = KomaUtil.CaputringKoma(kyokumen.GetCells(tolocation))
                If KomaUtil.KomaKind(capturedKoma) = Koma.LI Then
                    Return Nothing
                End If
            End If
            moveKomaInfo.MovingKoma = movingKomaValue
            Return tolocation
        End Function



        Public Function GetTeWithMouseUp(mousePt As Point) As Move

            Dim tolocation As Position = GetToLocationAndMovingKoma(mousePt)
            Dim movingKomaValue As Byte = moveKomaInfo.MovingKoma


            If Not tolocation Is Nothing Then

                Return New UI.Form.Move(moveKomaInfo.From, tolocation, movingKomaValue)
            End If

            Return Nothing

        End Function






        Private Function MakeMovingBackBitmap(l As Position, komaValue As Byte) As Rectangle
            Dim graphics As Graphics = graphics.FromImage(Me._movingBackBitmap)
            Dim rect As Rectangle = New Rectangle(0, 0, Me._movingBackBitmap.Width, Me._movingBackBitmap.Height)
            graphics.DrawImage(_currentBitmap, rect)
            Dim rectangle As Rectangle
            If l.IsInCell Then
                rectangle = Me.GetMasuRect(l)
                graphics.DrawImage(_baseBitmap, rectangle, rectangle, GraphicsUnit.Pixel)
            ElseIf l.IsCaptured Then
                Dim num As Integer = Me.kyokumen.CapturedKomaCount(komaValue)
                Me.DrawMochigoma(graphics, komaValue, num - 1)

                Dim mochigomaRect As Rectangle = Me.GetMochigomaRect(komaValue)

                Dim r As Rectangle = New Rectangle(mochigomaRect.Right, mochigomaRect.Top, 28, mochigomaRect.Height)
                Dim rectangle2 As Rectangle = Drawing.Rectangle.Union(mochigomaRect, r)

                rectangle = rectangle2
            End If
            graphics.Dispose()
            Return rectangle
        End Function


        Private Function GetKomaPosition(mousePt As Point) As Position
            Dim col As Integer = 0
            Dim row As Integer = 0
            Dim num As Integer = mousePt.X - (Me.boardRect.Left + 28)
            Dim num2 As Integer = mousePt.Y - (Me.boardRect.Top + 36)
            If num >= 0 AndAlso num2 >= 0 Then
                col = num \ Me.komaSize.Width + 1
                row = num2 \ Me.komaSize.Height + 1
                If Me.IsBoardViewRotated Then
                    col = SIZE_X - (col - 1)
                    row = SIZE_Y - (row - 1)
                End If
            End If
            If UI.Form.Board.SIZE_X < col Then
                col = UI.Form.Board.SIZE_X
            End If
            If UI.Form.Board.SIZE_Y < row Then
                row = UI.Form.Board.SIZE_Y
            End If
            If col < 1 Then
                col = 1
            End If
            If row < 1 Then
                row = 1
            End If
            Return New Position(col, row)
        End Function



        Private Sub BoardViewer_MouseMove(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseMove
            Dim rectangle As Rectangle = New Rectangle(Me.moveKomaInfo.MouseDownPt.X - SystemInformation.DragSize.Width \ 2, Me.moveKomaInfo.MouseDownPt.Y - SystemInformation.DragSize.Height \ 2, SystemInformation.DragSize.Width, SystemInformation.DragSize.Height)
            If Me.moveKomaInfo.IsMouseDown AndAlso Me.moveKomaInfo.IsValidPosition AndAlso Not Me.moveKomaInfo.IsNowMove AndAlso Not Me.moveKomaInfo.IsNowDrag AndAlso Not rectangle.Contains(e.Location) Then
                Me.moveKomaInfo.IsNowDrag = True
            End If
            If Me.moveKomaInfo.IsNowMove OrElse Me.moveKomaInfo.IsNowDrag Then
                If Not Me.moveKomaInfo.IsMovingInvalidate Then
                    Me.moveKomaInfo.MovingKomaRect = New Rectangle(e.X - Me.komaSize.Width \ 2, e.Y - Me.komaSize.Height \ 2, Me.komaSize.Width, Me.komaSize.Height)
                    Me.moveKomaInfo.InvalidRect = rectangle.Union(Me.moveKomaInfo.MovingKomaPrevRect, Me.moveKomaInfo.MovingKomaRect)
                    Me.moveKomaInfo.MovingKomaPrevRect = Me.moveKomaInfo.MovingKomaRect
                    Dim rectangle2 As Rectangle = rectangle.Intersect(Me.moveKomaInfo.InvalidRect, Me.ClientRectangle)
                    If rectangle2.Width > 0 AndAlso rectangle2.Height > 0 Then
                        Me.moveKomaInfo.IsMovingInvalidate = True
                        Me.Invalidate(Me.moveKomaInfo.InvalidRect)
                    End If
                End If
            End If
        End Sub




        Private Sub BoardViewer_MouseUp(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseUp
            Dim te As UI.Form.Move = GetTeWithMouseUp(e.Location)
            Me.moveKomaInfo = New MoveKomaInfo
            If te Is Nothing Then
                DrawCurrentBitmap()
                Exit Sub
            End If
            Dim editingeventArgs As New EditingEventArgs
            editingeventArgs.MovingValue = te
            RaiseEvent Editing(sender, editingeventArgs)

            If editingeventArgs.Cancel Then
                DrawCurrentBitmap()
                Exit Sub
            End If

            kyokumen = New UI.Form.Board(Me.kyokumen)
            If editingeventArgs.IsMove Then
                kyokumen.DoMove(te)
            Else
                kyokumen.DoEdit(te)
            End If

            DrawCurrentBitmap()

            Dim editedEventArgs As New EditedEventArgs
            editedEventArgs.MovingValue = te
            RaiseEvent Edited(sender, editedEventArgs)

        End Sub

        Private Sub BoardViewer_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseDown
            If e.Button = MouseButtons.Left Then
                MakeMovingKomaInfo(e.Location)
            ElseIf e.Button = Windows.Forms.MouseButtons.Right Then
                MouseRightClick(sender, e)
            End If

        End Sub

        Private Sub MouseRightClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs)
            If boardRect.Contains(e.Location) Then
                Dim l As Position = GetKomaPosition(e.Location)
                Dim koma As Koma = kyokumen.GetCells(l)
                Dim toggleKoma As Koma
                If koma = Form.Koma.GoteNI Then
                    toggleKoma = Form.Koma.SenteHI
                ElseIf koma = Form.Koma.GoteHI Then
                    toggleKoma = Form.Koma.SenteNI
                Else
                    toggleKoma = KomaUtil.OppositeKoma(koma)
                End If

                Dim te As UI.Form.Move = New UI.Form.Move(l, l, toggleKoma)

                Dim eventArgs As New EditingEventArgs
                eventArgs.MovingValue = te
                eventArgs.MouseRightClicked = True
                RaiseEvent Editing(sender, eventArgs)

                If eventArgs.Cancel Then
                    Exit Sub
                End If

                kyokumen = New UI.Form.Board(Me.kyokumen)
                kyokumen.DoEdit(te)
                DrawCurrentBitmap()

            End If
        End Sub

        Private Sub MakeMovingKomaInfo(p As Point)
            Dim koma As Koma = koma.Empty
            Dim l As Position = Nothing
            Dim isInCell As Boolean = Me.boardRect.Contains(p)
            Dim isInSenteKomadai As Boolean = Me.senteKomadaiRect.Contains(p)
            Dim isInGotekomadai As Boolean = Me.goteKomadaiRect.Contains(p)
            If isInCell Then
                l = Me.GetKomaPosition(p)
                koma = kyokumen.GetCells(l)
                Dim graphics As Graphics = graphics.FromImage(_currentBitmap)
                Dim masuRect As Rectangle = Me.GetMasuRect(l.X, l.Y)
                graphics.DrawImage(_baseBitmap, masuRect, masuRect, GraphicsUnit.Pixel)
                If Not koma = Form.Koma.Empty Then
                    Dim image As Bitmap = imageLoader.GetKomaImage(koma)
                    graphics.DrawImage(image, masuRect)
                    graphics.Dispose()
                    Me.Invalidate(masuRect)
                End If
            ElseIf isInSenteKomadai OrElse
                    isInGotekomadai Then
                l = UI.Form.Position.Captured
                If isInSenteKomadai Then
                    koma = GetSenteKomadaiKomaValue(p)
                Else
                    koma = GetGoteKomadaiKomaValue(p)
                End If
                If koma = Form.Koma.Empty Then
                    Exit Sub
                End If
                If _isBoardViewRotated Then
                    koma = KomaUtil.OppositeKoma(koma)
                End If
                If _kyokumen.CapturedKomaCount(koma) <= 0 Then
                    Exit Sub
                End If

            End If

            If l IsNot Nothing AndAlso Not koma = Form.Koma.Empty Then
                Me.moveKomaInfo.MovingKoma = koma
                Me.moveKomaInfo.IsValidPosition = True
                Me.moveKomaInfo.MovingKomaPrevRect = Me.MakeMovingBackBitmap(l, koma)
                Me.moveKomaInfo.From = l
                Me.moveKomaInfo.MouseDownPt = p
                Me.moveKomaInfo.IsMouseDown = True
                Me._movingKomaBitmap = imageLoader.GetKomaImage(Me.moveKomaInfo.MovingKoma)
            End If

        End Sub

        Public Function GetSenteKomadaiKomaValue(mousePt As Point) As Koma
            Dim dan As Byte = 0
            If Me.senteKomadaiRect.Left < mousePt.X AndAlso mousePt.X < Me.senteKomadaiRect.Left + Me.goteKomadaiRect.Width Then
                If mousePt.Y > Me.senteKomadaiRect.Top Then
                    dan = CByte(((mousePt.Y - senteKomadaiRect.Top) \ Me.komaSize.Height) + 1)
                    Debug.Assert(1 <= dan AndAlso dan <= 3)
                End If
            End If
            Return _senteMochigoma(dan - 1)
        End Function

        Public Function GetGoteKomadaiKomaValue(mousePt As Point) As Koma
            Dim dan As Byte = 0
            If Me.goteKomadaiRect.Left < mousePt.X AndAlso mousePt.X < Me.goteKomadaiRect.Left + Me.goteKomadaiRect.Width AndAlso mousePt.Y < Me.goteKomadaiRect.Bottom Then
                dan = CByte((mousePt.Y - (Me.goteKomadaiRect.Top + 11)) \ Me.komaSize.Height + 1)
                Debug.Assert(1 <= dan AndAlso dan <= 3)
            End If
            Return _goteMochigoma(dan - 1)
        End Function


        Private Sub BoardViewer_Paint(sender As System.Object, e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
            If Me.moveKomaInfo.IsMovingInvalidate Then
                e.Graphics.DrawImage(Me._movingBackBitmap, Me.moveKomaInfo.InvalidRect, Me.moveKomaInfo.InvalidRect, GraphicsUnit.Pixel)
                e.Graphics.DrawImage(Me._movingKomaBitmap, Me.moveKomaInfo.MovingKomaRect)
                Me.moveKomaInfo.IsMovingInvalidate = False
            Else
                If _currentBitmap Is Nothing Then
                    Initialize()
                    kyokumen = New UI.Form.Board
                    DrawCurrentBitmap()
                    e.Graphics.DrawImage(_currentBitmap, 0, 0)
                Else
                    e.Graphics.DrawImage(_currentBitmap, 0, 0)
                End If
            End If
        End Sub


    End Class

End Namespace
