﻿Imports System.IO
Imports System.Net
Imports System.Text
Imports System.Collections

Public Class HttpPostUtl
    Shared Function HttpPost(url As String, vals As Hashtable, cc As CookieContainer, encoder As Encoding) As String
        Dim param As String = ""
        For Each k As String In vals.Keys
            param += String.Format("{0}={1}&", k, vals(k))
        Next
        Dim data As Byte() = Encoding.ASCII.GetBytes(param)

        ' リクエストの作成
        Dim req As HttpWebRequest _
          = CType(WebRequest.Create(url), HttpWebRequest)
        req.Method = "POST"
        req.ContentType = "application/x-www-form-urlencoded"
        req.ContentLength = data.Length
        req.CookieContainer = cc

        ' ポスト・データの書き込み
        Dim reqStream As Stream = req.GetRequestStream()
        reqStream.Write(data, 0, data.Length)
        reqStream.Close()

        Dim res As WebResponse = req.GetResponse()

        ' レスポンスの読み取り
        Dim resStream As Stream = res.GetResponseStream()
        Dim sr As StreamReader = New StreamReader(resStream, encoder)
        Dim result As String = sr.ReadToEnd()
        sr.Close()
        resStream.Close()

        Return result
    End Function
End Class
