/*******************************************************************************
* Database --
* 非常に単純なデータベースプログラムで
* プログラムに記述されたリスト中に名前を探す
* 使用方法:
*     database
*             プログラムは名前の入力を求める。
*             名前を入力すると、その名前がリスト中にあるかどうかを通知する。
*
*             何も入力しないでリターンキーを押すと終了。
********************************************************************************/
#define STRING_LENGTH 80
#include <stdio.h>
#include <string.h>

extern FILE *save_file;
extern FILE *playback_file;
;
extern char *extended_fgets(char *, int, FILE *);

int main(int argc,char *argv[])
{
	char name[STRING_LENGTH]; //探し出す名前
	char *save_file_name;
	char *playback_file_name;
	
	int lookup(char const *const name);//名前を探す
	
	while((argc> 1) && (argv[1][0] == '-')) {
		switch(argv[1][1]){
			// -S<file> 保存ファイルを指定
			case 'S':
				save_file_name = &argv[1][2];
				save_file = fopen(save_file_name, "w");
				if (save_file == NULL){
					fprintf(stderr,
						"Warning: Unable to open save file %s\n", 
						save_file_name);
				}
				break;
			case 'P':
				playback_file_name = &argv[1][2];
				playback_file = fopen(playback_file_name, "r");
				if (playback_file == NULL) {
					fprintf(stderr,
						"Error:Unable to open playback file %s\n",
						playback_file_name);
					exit(8);
				}
				break;
			default:
				fprintf(stderr,"Bad option: %s\n", argv[1]);
				exit(8);
		}
		--argc;
		++argv;
	}
	
	while (1) {
		printf("Enter name: ");
		extended_fgets(name, sizeof(name), stdin);
		
		//リターンキーだけかどうかをチェック
		//改行には1文字必要である
		if (strlen(name) <= 1){
			break;
		}
		
		//改行文字を取り除く
		name[strlen(name) - 1] = '\0';
		
		if(lookup(name)){
			printf("%s is in the list\n", name);
		}else{
			printf("%s is not in the list\n", name);
		}
	}
	return 0;
}
/*******************************************************************************
* lookup -- リスト中で名前を探す。
* パラメータ
* name -- 探し出す名前
* 戻り値
* 1 -- 名前がリストにある。
* 0 -- 名前がリストにない。
********************************************************************************/
int lookup(char const *const name)
{
	//データベース中の人名リスト
	//注:最後は行終端を表すNULL
	static char *list[] = {
		"John",
		"Jim",
		"Jane",
		"Clyde",
		NULL
	};
	
	int index;
	for (index = 0; list[index] != NULL; ++index){
		if(strcmp(list[index], name) == 0){
			return 1;
		}
	}
	return 0;
}
