﻿Namespace Iterator.Core

    Public Class BookShelf
        Implements IEnumerable

        Private _books() As Book
        Private _last As Integer = 0

        Public Sub New(ByVal maxSize As Integer)
            ReDim _books(maxSize - 1)
        End Sub

        Public ReadOnly Property Length() As Integer
            Get
                Return _last
            End Get
        End Property

        Public ReadOnly Property Book(ByVal index As Integer) As Book
            Get
                Return _books(index)
            End Get
        End Property

        Public Sub AppendBook(ByVal book As Book)
            _books(_last) = book
            _last += 1
        End Sub

        Public Function GetEnumerator() As IEnumerator Implements IEnumerable.GetEnumerator
            Return New BookShelfEnumerator(Me)
        End Function

    End Class

End Namespace

