﻿using System;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Threading;

namespace Server
{
    public partial class Form1 : Form
    {
        private Socket mySock;
        private TcpListener tcpL;
        private NetworkStream netStream;
        private Thread tMain;

        public Form1()
        {
            InitializeComponent();
        }

        delegate void appendTextDelegate(string text);
        private void appendText(string text)
        {
            rbox_show.AppendText(text);
        }
        

        private void btn_start_Click(object sender, EventArgs e)
        {
            tcpL = new TcpListener(1888);
            tcpL.Start();
            rbox_show.AppendText("\r\n接続待ち......\r\n");
            tMain = new Thread(new ThreadStart(waitConnect));
            tMain.Start();
        }
        private void waitConnect()
        {
            while (true)
            {
                mySock = tcpL.AcceptSocket();
                if (mySock.Connected)
                {
                    Invoke(new appendTextDelegate(appendText), "接続しました。\r\n");
                    Thread t = new Thread(new ThreadStart(receive));
                    t.IsBackground = true;
                    t.Start();
                }
            }
        }
        private void receive()
        {
            while (true)
            {
                try
                {
                    netStream = new NetworkStream(mySock);
                    byte[] bb = new byte[1024];
                    netStream.Read(bb, 0, bb.Length);
                    string msgFromClient = System.Text.Encoding.UTF8.GetString(bb);
                    Invoke(new appendTextDelegate (appendText),msgFromClient);
                }
                catch
                {
                    //
                }
            }
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            netStream.Close();
            mySock.Close();
            tMain.Abort();
            tcpL.Stop();
            rbox_show.AppendText("\r\n停止しています。\r\n");
        }
    }
}
