﻿using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System;

namespace Client
{
    public partial class Form1 : Form
    {
        private TcpClient tcpC = new TcpClient();
        private NetworkStream netStream;
        private Int32 port;

        public Form1()
        {
            InitializeComponent();
        }

        private void btn_connect_Click(object sender, EventArgs e)
        {
            port = Int32.Parse(tbox_port.Text.Trim());
            String IP = tbox_ip.Text.Trim();
            try
            {
                tcpC.Connect(IP, port);
                netStream = tcpC.GetStream();
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        private void sendMsg()
        {
            byte[] bb = new byte[1024];
            String sendMsg = "Client >>> " + rbox_msg.Text + "\r\n";
            bb = System.Text.Encoding.UTF8.GetBytes(sendMsg.ToCharArray());
            netStream.Write(bb, 0, bb.Length);
            netStream.Flush();
        }

        private void btn_msg_Click(object sender, EventArgs e)
        {
            sendMsg();
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            netStream.Close();
            tcpC.Close();
        }
    }
}
