﻿Imports System.Reflection

Namespace Image
    Public Class Loader

        Public Shared _instance As New Loader
        Public Shared Function GetInstance() As Loader
            Return _instance
        End Function

        Private Sub New()
            GetResourcesFromExecutingAssembly()
        End Sub

        Private executingAssembly As Assembly = Assembly.GetExecutingAssembly()
        Public Function GetBitmapFromExecutingAssembly(ByVal Name As String) As Bitmap
            Return New Bitmap(executingAssembly.GetManifestResourceStream(Name))
        End Function

        Private Sub GetResourcesFromExecutingAssembly()

            GetResourcesFromExecutingAssemblyMapChip()
            GetResourcesFromExecutingAssemblyUnit()
            GetResourcesFromExecutingAssemblyUnitIfo()

        End Sub

        Private _mapChipBitmap(18 - 1) As Bitmap
        Private _unitInfoBitmap(6 * 4 - 1) As Bitmap
        Private _unitJpnBitmap(15 * 8 - 1) As Bitmap
        Private _unitUsaBitmap(15 * 8 - 1) As Bitmap

        Public ReadOnly Property MapChipBitmap As Bitmap()
            Get
                Return _mapChipBitmap
            End Get
        End Property

        Public ReadOnly Property UnitInfoBitmap As Bitmap()
            Get
                Return _unitInfoBitmap
            End Get
        End Property

        Public ReadOnly Property UnitJpnBitmap As Bitmap()
            Get
                Return _unitJpnBitmap
            End Get
        End Property

        Public ReadOnly Property UnitUsaBitmap As Bitmap()
            Get
                Return _unitUsaBitmap
            End Get
        End Property

        Public Function GetMapChipImage(ByVal mapChipValue As UShort) As Bitmap
            Debug.Assert(0 <= mapChipValue AndAlso mapChipValue < 13)
            If mapChipValue = 0 Then
                Return _mapChipBitmap(0)
            End If
            Return _mapChipBitmap(mapChipValue + 5)
        End Function

        Public Function GetUnitImage(ByVal unit As GameLogic.Unit) As Bitmap
            Dim unitBitmap() As Bitmap
            If unit.side = GameLogic.Side.JPN Then
                unitBitmap = _unitJpnBitmap
            Else
                unitBitmap = _unitUsaBitmap
            End If

            Dim imageIdxs As Integer() = {0, 0, 1, 2, 3, 5, 6, 7, 9, 12, 13, 14}
            Dim row As Integer
            Dim col As Integer
            If unit.kind < imageIdxs.Length Then
                row = imageIdxs(unit.kind)
                col = CInt(unit.direction / 360 * 8) Mod 8
            Else
                '軍港など方向なしのユニット
                Dim imageColIdxs As Integer() = {0, 1, 2, 5, 6, 7}
                row = 11
                col = imageColIdxs(unit.kind - GameLogic.UnitKind.SP)
            End If
            Return unitBitmap(row * 8 + col)

        End Function

        Private Sub GetResourcesFromExecutingAssemblyMapChip()


            For i As Integer = 0 To 6 - 1
                For j As Integer = 0 To 3 - 1
                    _mapChipBitmap(j * 6 + i) = GetBitmapFromExecutingAssembly(
                       String.Format("THYS1.mapChip{0}.bmp", j * 6 + i))
                Next
            Next

        End Sub

        Private Sub GetResourcesFromExecutingAssemblyUnit()

            For i As Integer = 0 To 8 - 1
                For j As Integer = 0 To 15 - 1
                    Dim rect As New Rectangle(i * 80 + 1, j * 80 + 1, 80 - 2, 80 - 2)
                    _unitJpnBitmap(j * 8 + i) = GetBitmapFromExecutingAssembly(
                        String.Format("THYS1.unitJpn{0}.bmp", j * 8 + i))
                    _unitUsaBitmap(j * 8 + i) = GetBitmapFromExecutingAssembly(
                        String.Format("THYS1.unitUsa{0}.bmp", j * 8 + i))
                    Dim MaskColor As Color = Color.FromArgb(255, 0, 255)
                    _unitJpnBitmap(j * 8 + i).MakeTransparent(MaskColor)
                    _unitUsaBitmap(j * 8 + i).MakeTransparent(MaskColor)
                Next
            Next
        End Sub



        Public Function GetUnitInfoImage(ByVal unit As GameLogic.Unit) As Bitmap
            Dim kindOfsets As Integer() = {0, 1, 2, 3, 4, 6, 5, 0, 0, 0, 7, 0, 0, 9}
            Dim offset As Integer = 0
            If GameLogic.UnitKind.BB <= unit.kind AndAlso _
                  unit.kind <= GameLogic.UnitKind.AF Then
                offset = kindOfsets(unit.kind)
            End If
            If offset = 0 Then
                Return Nothing
            End If
            If unit.side = GameLogic.Side.JPN Then
                offset += 0
            ElseIf unit.side = GameLogic.Side.USA Then
                offset += 12
            End If

            Return _unitInfoBitmap(offset - 1)

        End Function

        Private Sub GetResourcesFromExecutingAssemblyUnitIfo()

            For j As Integer = 0 To 4 - 1
                For i As Integer = 0 To 6 - 1
                    Dim rect As New Rectangle(i * 120, j * 440, 120, 440)
                    _unitInfoBitmap(j * 6 + i) = GetBitmapFromExecutingAssembly(
                        String.Format("THYS1.unitInfo{0}.bmp", j * 6 + i))
                Next
            Next

        End Sub



    End Class

End Namespace
