﻿Imports System
Imports System.IO

Namespace GameLogic

    Public Class Map

        Private Sub New()
        End Sub
        Private Shared _instance As New Map
        Public Shared Function GetInstance() As Map
            Return _instance
        End Function

        Private _data(256, 256) As UShort
        Public Function data(ByVal x As Integer, ByVal y As Integer) As UShort
            Return _data(x, y)
        End Function

        Public Sub Load(ByVal fileName As String)
            Dim fileFullPath As String = Utils.PathUtil.GetExePath + "\Map\" + fileName
            Dim fs As New FileStream(fileFullPath, FileMode.Open, FileAccess.Read)

            Dim fileSize As Integer = CInt(fs.Length) ' ファイルのサイズ
            Dim buf(fileSize - 1) As Byte ' データ格納用配列

            Dim readSize As Integer ' Readメソッドで読み込んだバイト数
            readSize = fs.Read(buf, 0, fileSize)
            Debug.Assert(readSize = 256 * 256 * 2)
            For i As Integer = 0 To 248 - 1
                For j As Integer = 0 To 256 - 1
                    _data(j, i) = BitConverter.ToUInt16(buf, (i * 256 + j) * 2)
                Next
            Next

        End Sub

        Public ReadOnly Property Max As Point
            Get
                Return New Point(256 * 80, 256 * 80)
            End Get
        End Property

    End Class

End Namespace

