﻿Imports System.Drawing

Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports THYS1.Image



'''<summary>
'''LoaderTest のテスト クラスです。すべての
'''LoaderTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class LoaderTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''GetBitmapFromExecutingAssembly のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub GetBitmapFromExecutingAssemblyTest()
        Dim target As Loader = Loader.GetInstance
        Dim actual As Bitmap = target.GetBitmapFromExecutingAssembly("THYS1.unitInfo.bmp")
        Assert.IsTrue(actual IsNot Nothing)
    End Sub

    <TestMethod()> _
    Public Sub GetBitmapFromExecutingAssemblyPerfomanceTest()

        Dim target As Loader = Loader.GetInstance
        Dim tm1 As DateTime = Now()
        For i As Integer = 0 To 100
            Dim actual As Bitmap = target.GetBitmapFromExecutingAssembly("THYS1.unitInfo.bmp")
        Next
        Dim tm2 As DateTime = Now()
        Dim ts As TimeSpan = tm2.Subtract(tm1)
        Console.WriteLine(ts.TotalMilliseconds)
        Assert.IsTrue(ts.TotalMilliseconds < 1000)
    End Sub

    <TestMethod()> _
    Public Sub GetInstancePerfomanceTest()
        Dim tm1 As DateTime = Now()
        Dim target As Loader = Loader.GetInstance
        Dim tm2 As DateTime = Now()
        Dim ts As TimeSpan = tm2.Subtract(tm1)
        Console.WriteLine(ts.TotalMilliseconds)
        Assert.IsTrue(ts.TotalMilliseconds < 1000)
    End Sub

    <TestMethod()> _
    Public Sub GetInstancePerfomanceTest2()
        Dim tm1 As DateTime = Now()
        Dim target As LoaderMakeVer = LoaderMakeVer.GetInstance
        Dim tm2 As DateTime = Now()
        Dim ts As TimeSpan = tm2.Subtract(tm1)
        Console.WriteLine(ts.TotalMilliseconds)
        Assert.IsTrue(ts.TotalMilliseconds < 5000)
    End Sub

End Class
