﻿Namespace UI

    Public Class frmUnit

        Private _unit As GameLogic.Unit

        Public Sub SelectUnit(ByVal unit As GameLogic.Unit)
            _unit = unit
            Draw()
        End Sub

        Private Sub Draw()
            DrawKindName()
            DrawDamage()
            DrawUnitImage()
        End Sub

        Private Sub DrawKindName()
            Dim kindNames As String() = {
                "",
                "戦艦",
                "巡洋艦",
                "駆逐艦",
                "潜水艦",
                "軽空母",
                "正規空母",
                "戦闘機",
                "攻撃機",
                "戦略爆撃機",
                "揚陸艇",
                "陸上戦闘機",
                "軍港",
                "航空基地",
                "都市",
                "歩兵陣地",
                "トーチカ陣地",
                "要塞"}
            lblKind.Text = kindNames(_unit.kind)
        End Sub

        Private Sub DrawDamage()
            Dim damage As Double = GetDamage(_unit)
            lblHp.Text = GetDamageName(damage)
        End Sub

        Private Sub DrawUnitImage()
            Dim unitImage As Bitmap = Image.Loader.GetInstance.GetUnitInfoImage(_unit)
            If unitImage IsNot Nothing Then
                PictureBox1.Image = unitImage
            Else
                Dim bmp As Bitmap = New Bitmap(PictureBox1.Width, PictureBox1.Height, Imaging.PixelFormat.Format32bppArgb)
                Dim g As Graphics = Graphics.FromImage(bmp)
                Dim rect As Rectangle = New Rectangle(0, 0, bmp.Width, bmp.Height)
                g.FillRectangle(Brushes.Aqua, rect)
                PictureBox1.Image = bmp
            End If
        End Sub

        Private Function GetDamage(ByVal unit As GameLogic.Unit) As Double
            Dim damage As Double = 0
            If _unit.hp_max <> 0 Then
                damage = (_unit.hp_max - _unit.hp) / _unit.hp_max
            End If
            Return damage
        End Function

        Private Function GetDamageName(damage As Double) As String
            Dim damageName As String = String.Empty
            If damage <= 0.0 Then
                damageName = "損傷無"
            ElseIf damage < 0.25 Then
                damageName = "軽損傷"
            ElseIf damage < 0.5 Then
                damageName = "小破"
            ElseIf damage < 0.75 Then
                damageName = "中破"
            Else
                damageName = "大破"
            End If
            Return damageName
        End Function



    End Class

End Namespace

