﻿Imports THYS1.Utils

Namespace UI

    Public Class frmScenarioSelect


        Private Sub frmScenarioSelect_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load

            Dim ScenarioDirName = PathUtil.GetExePath() + "\Scenario"
            Dim fileNames As String() = PathUtil.GetDirectryFileNames(ScenarioDirName, "*.lua")
            Dim list As New List(Of ScenarioListBoxItem)
            For Each fileName In fileNames
                Dim item As New ScenarioListBoxItem
                item.FullPath = fileName
                item.Name = System.IO.Path.GetFileNameWithoutExtension(fileName)
                list.Add(item)
            Next
            ListBox1.Items.AddRange(list.ToArray)
            ListBox1.DisplayMember = "Name"
        End Sub

        Private Sub btnOk_Click(sender As System.Object, e As System.EventArgs) Handles btnOk.Click
            If ListBox1.SelectedItem Is Nothing Then
                MessageBox.Show("シナリオを選択してください。")
                Exit Sub
            End If
            Dim item As ScenarioListBoxItem = DirectCast(ListBox1.SelectedItem, ScenarioListBoxItem)
            Dim fileName As String = System.IO.Path.GetFileName(item.FullPath)
            GameLogic.ScenarioLoader.GetInstance.Load(fileName)

            Dim _formDispacher As FormDispatcher = FormDispatcher.GetInstance()
            _formDispacher.Initialize(Me)
            _formDispacher.ShowFrmMainAndEtc()
 
        End Sub



    End Class

End Namespace