﻿Namespace UI

    Public Class frmMiniMap

        Private _formDispacher As FormDispatcher = FormDispatcher.GetInstance

        Private _y As Integer
        Private _x As Integer
        Private _width As Integer = 8
        Private _height As Integer = 8

        Private image As Bitmap
        Private baseImage As Bitmap
        Private g As Graphics

        Private Sub frmMiniMap_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
            BaseImageDraw()

            image = New Bitmap(PictureBox1.Width, PictureBox1.Height)
            g = Graphics.FromImage(image)

            CurrentImageDraw()
        End Sub

        Public Sub SetBoxPostion(ByVal x As Integer, ByVal y As Integer)
            _y = y
            _x = x
            CurrentImageDraw()
        End Sub

        Public Sub SetBoxSize(ByVal width As Integer, ByVal height As Integer)
            _width = width
            _height = height
            CurrentImageDraw()
        End Sub

        Private Sub BaseImageDraw()
            baseImage = New Bitmap(PictureBox1.Width, PictureBox1.Height)
            Dim g As Graphics = Graphics.FromImage(baseImage)
            Dim brush As New SolidBrush(Color.Aqua)
            g.FillRectangle(brush, New Rectangle(0, 0, baseImage.Width, baseImage.Height))

            For i As Integer = 0 To 256 - 1
                For j As Integer = 0 To 256 - 1
                    Dim value As UShort = GameLogic.Map.GetInstance.data(i, j)
                    If value <> 0 Then
                        g.FillRectangle(Brushes.Green, i, j, 1, 1)
                    End If
                Next
            Next
        End Sub



        Private Sub CurrentImageDraw()
            If g Is Nothing Then
                Exit Sub
            End If
            ' Dim g As Graphics = Graphics.FromImage(image)
            g.DrawImage(baseImage, 0, 0)
            Dim pen As Pen = Pens.Black
            Dim rect As Rectangle = New Rectangle(_x \ 80, _y \ 80, _width, _height)
            g.DrawRectangle(pen, rect)

            PictureBox1.Image = image
        End Sub


        Private Sub PictureBox1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseDown
            If e.Button = Windows.Forms.MouseButtons.Left Then
                _x = e.Location.X * 80 + 40
                _y = e.Location.Y * 80 + 40
                CurrentImageDraw()
                _formDispacher.SetfrmMainPostion(_x, _y)
            End If
        End Sub
    End Class

End Namespace
