﻿Namespace UI

    Public Class frmMain

        Private _formDispacher As FormDispatcher = FormDispatcher.GetInstance

        Private _currentY As Integer = 40
        Private _currentX As Integer = 40

        Private g As Graphics
        Private imageAll As Bitmap


        Private Sub frmMain_Resize(sender As System.Object, e As System.EventArgs) Handles MyBase.Resize
            Dim pbSize As Size = New Size(Me.Size.Width - 16, Me.Size.Height - 50)
            MainPictureBox.Size = pbSize
            imageAll = New Bitmap(MainPictureBox.Width, MainPictureBox.Height)
            g = Graphics.FromImage(imageAll)
            DrawCombat()
        End Sub

        Private Sub frmMain_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
            DrawCombat()
        End Sub

        Public Sub SetCurrentPostion(ByVal x As Integer, ByVal y As Integer)
            _currentY = y
            _currentX = x
            DrawCombat()
        End Sub

        Private Sub DrawCombat()
            DrawMap()
            DrawUnits()
            MainPictureBox.Image = imageAll
        End Sub


        Private Sub DrawMap()
            Dim top As Integer = _currentY
            Dim left As Integer = _currentX
            Dim topIdx As Integer = top \ 80
            Dim leftIdx As Integer = left \ 80
            Dim topOffset As Integer = top Mod 80
            Dim leftOffset As Integer = left Mod 80

            '結合後の画像のサイズは各画像を縦に２枚並べたサイズ
            If g Is Nothing Then
                Exit Sub
            End If


            g.Clear(Color.Blue)

            Dim iMax As Integer = imageAll.Width \ 80 + 1
            Dim jMax As Integer = imageAll.Height \ 80 + 1
            For i As Integer = 0 To iMax
                For j As Integer = 0 To jMax
                    If i + topIdx > 256 OrElse j + leftIdx > 256 Then
                        Continue For
                    End If
                    Dim mapChipValue As UShort = GameLogic.Map.GetInstance.data(i + leftIdx, j + topIdx)
                    Dim bmpTemp As Bitmap = Image.Loader.GetInstance.GetMapChipImage(mapChipValue)
                    Dim x As Integer = i * bmpTemp.Width - leftOffset
                    Dim y As Integer = j * bmpTemp.Height - topOffset
                    g.DrawImage(bmpTemp, x, y, bmpTemp.Width, bmpTemp.Height)
                Next
            Next


        End Sub

        Private Sub DrawUnits()
            For Each unit As GameLogic.Unit In GameLogic.UnitList.JpnUnit.List
                DrawUnit(unit)
            Next
            For Each unit As GameLogic.Unit In GameLogic.UnitList.UsaUnit.List
                DrawUnit(unit)
            Next
        End Sub

        Private Sub DrawUnit(ByVal unit As GameLogic.Unit)
            Dim x As Integer = unit.x - _currentX
            Dim y As Integer = unit.y - _currentY

            If -40 < x AndAlso x < MainPictureBox.Width AndAlso _
                -40 < y AndAlso y < MainPictureBox.Height Then
                Dim bmpTemp As Bitmap = Image.Loader.GetInstance.GetUnitImage(unit)
                g.DrawImage(bmpTemp, x - 39, y - 39, bmpTemp.Width, bmpTemp.Height)
            End If

        End Sub

        Private Sub MainPictureBox_SizeChanged(sender As System.Object, e As System.EventArgs) Handles MainPictureBox.SizeChanged
            Dim width As Integer = MainPictureBox.Width \ 80 + 1
            Dim height As Integer = MainPictureBox.Height \ 80 + 1
            _formDispacher.SetfrmMiniMapBoxSize(width, height)
        End Sub

        Private Sub MainPictureBox_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MainPictureBox.MouseDown
            If e.Button = Windows.Forms.MouseButtons.Left Then
                Dim counterViewLocation = e.Location
                Dim absoluteLocation As Point
                absoluteLocation.X = counterViewLocation.X + _currentX
                absoluteLocation.Y = counterViewLocation.Y + _currentY
                Combat_MouseLeftDown(absoluteLocation)
            End If
        End Sub

        Private Sub Combat_MouseLeftDown(ByVal location As Point)
            For Each unit As GameLogic.Unit In GameLogic.UnitList.JpnUnit.List
                If IsUnitSelect(unit, location) Then
                    _formDispacher.SelectUnit(unit)
                    Exit For
                End If
            Next
            For Each unit As GameLogic.Unit In GameLogic.UnitList.UsaUnit.List
                If IsUnitSelect(unit, location) Then
                    _formDispacher.SelectUnit(unit)
                    Exit For
                End If
            Next
        End Sub

        Private Function IsUnitSelect(ByVal unit As GameLogic.Unit, location As Point) As Boolean
            If unit.x - 20 <= location.X AndAlso location.X <= unit.x + 20 AndAlso _
               unit.y - 20 <= location.Y AndAlso location.Y <= unit.y + 20 Then
                Return True
            End If
            Return False
        End Function

        Private _MouseLocation As Point

        Private Sub MoveTimer_Tick(sender As System.Object, e As System.EventArgs) Handles MoveTimer.Tick
            If IsMoveDown() Then
                If _currentY <= GameLogic.Map.GetInstance.Max.Y Then
                    _currentY += 5
                End If
            End If
            If IsMoveUp() Then
                If 0 < _currentY Then
                    _currentY -= 5
                End If
            End If
            If IsMoveRight() Then
                If _currentX <= GameLogic.Map.GetInstance.Max.X Then
                    _currentX += 5
                End If
            End If
            If IsMoveLeft() Then
                If 0 < _currentX Then
                    _currentX -= 5
                End If
            End If
            DrawCombat()
            _formDispacher.SetfrmMiniMapBoxPosition(_currentX, _currentY)
        End Sub

        Private Sub MainPictureBox_MouseMove(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MainPictureBox.MouseMove
            _MouseLocation = e.Location
            If IsMoveLeft() OrElse _
                IsMoveRight() OrElse _
               IsMoveUp() OrElse _
                IsMoveDown() Then
                MoveTimer.Start()
            Else
                MoveTimer.Stop()
            End If

        End Sub

        Private Function IsMoveLeft() As Boolean
            Return _MouseLocation.X <= 10
        End Function

        Private Function IsMoveRight() As Boolean
            Return MainPictureBox.Width - 10 <= _MouseLocation.X
        End Function

        Private Function IsMoveUp() As Boolean
            Return _MouseLocation.Y <= 10
        End Function

        Private Function IsMoveDown() As Boolean
            Return MainPictureBox.Height - 10 <= _MouseLocation.Y
        End Function

    End Class

End Namespace
