﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting


Namespace GameLogic


    '''<summary>
    '''UnitListTest のテスト クラスです。すべての
    '''UnitListTest 単体テストをここに含めます
    '''</summary>
    <TestClass()> _
    Public Class UnitListTest


        Private testContextInstance As TestContext

        '''<summary>
        '''現在のテストの実行についての情報および機能を
        '''提供するテスト コンテキストを取得または設定します。
        '''</summary>
        Public Property TestContext() As TestContext
            Get
                Return testContextInstance
            End Get
            Set(value As TestContext)
                testContextInstance = value
            End Set
        End Property

#Region "追加のテスト属性"
        '
        'テストを作成するときに、次の追加属性を使用することができます:
        '
        'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        '<ClassInitialize()>  _
        'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
        'End Sub
        '
        'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        '<ClassCleanup()>  _
        'Public Shared Sub MyClassCleanup()
        'End Sub
        '
        '各テストを実行する前にコードを実行するには、TestInitialize を使用
        '<TestInitialize()>  _
        'Public Sub MyTestInitialize()
        'End Sub
        '
        '各テストを実行した後にコードを実行するには、TestCleanup を使用
        '<TestCleanup()>  _
        'Public Sub MyTestCleanup()
        'End Sub
        '
#End Region


        '''<summary>
        '''Add のテスト
        '''</summary>
        <TestMethod()> _
        Public Sub AddTest()
            Dim target As UnitList = New UnitList() ' TODO: 適切な値に初期化してください
            Dim unit As New Unit
            unit.x = 100
            unit.y = 50
            target.Add(unit)
            Assert.AreEqual(1, target.List.Count)
            Assert.AreEqual(100, target.List(0).x)
            Assert.AreEqual(50, target.List(0).y)
        End Sub
    End Class

End Namespace