#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#define MAX_CHAR 80
#define MAX_LINE 80
#define SUCCESS 0
#define ERROR_ARGUMENT_NUMBER 1
#define ERROR_CANNOT_OPEN_FILE 2
#define ERROR_CANNOT_CLOSE_FILE 3

char *ErrorMessage[4] = {
	"",
	"t@Cw肵ĂB",
	"t@CJ܂łB",
	"t@C܂łB"
};

int main(int argc, char* argv[]){
	FILE *fp;
	int i;
	char input[MAX_LINE][MAX_CHAR];
	int lineCount = 0;
	int result = SUCCESS;
	
	if (argc != 2){
		result = ERROR_ARGUMENT_NUMBER;
	} else {
		fp = fopen(argv[1], "r");
		if (fp == NULL) {
				result = ERROR_CANNOT_OPEN_FILE;
		} else { 
			while ( NULL != fgets(input[lineCount], MAX_CHAR, fp)){
				lineCount++;
			}
			if ( 0 != fclose(fp)){
				result = ERROR_CANNOT_CLOSE_FILE;
			}
		}
	}
	
	for (i = lineCount - 1; i >= 0; i--){
		printf(input[i]);
	}
	
	if (result != SUCCESS){
		printf("%s\n", ErrorMessage[result]);
	}
	return result;
}
