#include <iostream>
#include <iomanip>
#include  <time.h>
#include <string>

int dayOfWeak(int year, int month, int day){
	if ( month <= 2 )
	{
		year  -= 1;
		month += 12;
	}

	// jԍԂ
	return 
		(
			day
			+
			((8 + (13 * month)) / 5)
			+
			(year + (year / 4) - (year / 100) + (year / 400))
		)
		%
		7;
}
int isLeapYear(int y){
	return y % 4 == 0 && y % 100 != 0 || y % 400 == 0;
}
int dayCountOfMonth(int year, int month){
	int days[] = {31,28,31,30,31,30,31,31,30,31,30,31};
	if (isLeapYear(year)){
		days[1]++;
	}
	return days[month-1];
}
void printCalender(int year,int month){
	std::cout << year<<"N"<<month<<"\n";
	std::cout << "       y\n";
	int weakofday = dayOfWeak(year,month,1);
	for(int i=0; i<weakofday; i++){
		std::cout << "   ";
	}
	int maxDay = dayCountOfMonth(year, month);
	for(int day=1;day <= maxDay; day++){
		std::cout << std::setw(3) << std::right << day;
		weakofday++;
		if(weakofday % 7 == 0){
			std::cout << "\n";
		}
	}
}
int main(int argc, char *argv[]){
	if (argc == 1){
		time_t current = time(NULL);
    	struct tm  *local = localtime(&current);
    	printCalender(local->tm_year+1900,local->tm_mon + 1);
	} else if (argc == 3){
		auto year = std::atoi(argv[1]);
		auto month = std::atoi(argv[2]);
		printCalender(year,month);
	} else {
		std::cout << "g\n2010N2̃J_[\\n";
		std::cout << argv[0] << " 2010 2\n";
		return 1;
	}
	return 0;
}