﻿Imports System.Windows.Forms
Imports System.Drawing
Imports System.Drawing.Drawing2D
Namespace UI

    Public Class HexMapGrid
        Public Event GridClickEvent(ByVal e As HexMapGridMouseEventArgs)

        Public Property Map As Logic.Hexmap
        Private Grid As UI.Grid = New UI.Grid(10, 10, 25)

        Public Sub SetGridSize(ByVal width As Integer, ByVal height As Integer, ByVal scale As Integer)
            Grid = New UI.Grid(width, height, scale)
        End Sub

        Private Sub HexMapGrid_Paint(sender As Object, e As PaintEventArgs) Handles MyBase.Paint
            PictureBox1.Invalidate()
        End Sub

        Private Sub PictureBox1_Paint(sender As Object, e As PaintEventArgs) Handles PictureBox1.Paint

            If Map Is Nothing Then
                Exit Sub
            End If

            Dim g As Graphics = e.Graphics

            For y As Integer = 0 To Grid.Height - 1
                For x As Integer = 0 To Grid.Width - 1
                    Dim ps As Point() = Grid.Cell(x, y).points
                    Dim col = Grid.Cell(x, y).AbsoluteX
                    Dim row = Grid.Cell(x, y).AbsoluteY
                    If Map.ValidPosition(col, row) Then

                        g.DrawPolygon(Pens.Black, ps)
                        '楕円の領域を追加する
                        Dim gp As New GraphicsPath()
                        gp.AddPolygon(ps)

                        'Regionを作成する
                        Dim rgn As New Region(gp)

                        'クリッピング領域を変更する
                        g.Clip = rgn

                        '画像を読み込んでImageオブジェクトを作成する
                        Dim loder As Ryaku101.Common.Image.Loder = Ryaku101.Common.Image.Loder.GetInstance

                        Dim img As Drawing.Image = loder.FieldBmp(Map.Cell(col, row).FieldInstance.Type)
                        Debug.Assert(img.Size.Width = 32)
                        '画像を表示する
                        g.DrawImage(img, g.VisibleClipBounds)


                    End If
                Next
            Next
        End Sub

        Private Sub frmMainMap_Load(sender As Object, e As EventArgs) Handles MyBase.Load
            If Map Is Nothing Then
                Exit Sub
            End If
            HScrollBar1.Maximum = Map.Width
            VScrollBar1.Maximum = Map.Height
        End Sub

        Private Sub VScrollBar1_ValueChanged(sender As Object, e As EventArgs) Handles VScrollBar1.ValueChanged
            ScrollBarValueChanged()
        End Sub


        Private Sub HScrollBar1_ValueChanged(sender As Object, e As EventArgs) Handles HScrollBar1.ValueChanged
            ScrollBarValueChanged()
        End Sub

        Private Sub ScrollBarValueChanged()
            Grid.Top = VScrollBar1.Value
            Grid.Left = Logic.Hexmap.LeftIndex(VScrollBar1.Value) + HScrollBar1.Value
            PictureBox1.Invalidate()
        End Sub

        Private Sub PictureBox1_MouseClick(sender As Object, e As MouseEventArgs) Handles PictureBox1.MouseClick
            If Map Is Nothing Then
                Exit Sub
            End If
            For y As Integer = 0 To Grid.Height - 1
                For x As Integer = 0 To Grid.Width - 1
                    If UI.UIUtils.PointIsInPolygon(Grid.Cell(x, y).points, e.Location) Then
                        Dim cell As Logic.Cell = Map.Cell(Grid.Cell(x, y).AbsoluteX, Grid.Cell(x, y).AbsoluteY)
                        Dim eventArgs As New HexMapGridMouseEventArgs(e.Button, x, y, cell)
                        RaiseEvent GridClickEvent(eventArgs)
                        Exit Sub
                    End If
                Next
            Next
        End Sub


    End Class
End Namespace
