﻿Imports System.Drawing

Namespace UI

    Public Class Grid

        Public Property Top As Integer
        Public Property Left As Integer

        Private _cells As List(Of List(Of UI.Cell))
        Public ReadOnly Property Cell(ByVal x As Integer, ByVal y As Integer) As Cell
            Get
                Return _cells(y)(x)
            End Get
        End Property
        Private HexScale As Integer

        Private _height As Integer
        Public ReadOnly Property Height As Integer
            Get
                Return _height
            End Get
        End Property

        Private _width As Integer
        Public ReadOnly Property Width As Integer
            Get
                Return _width
            End Get
        End Property


        Public Sub New(ByVal width As Integer, ByVal height As Integer, ByVal HexScale As Integer)
            Me.HexScale = HexScale
            Me._height = height
            Me._width = width
            _cells = New List(Of List(Of Cell))
            For y As Integer = 0 To height - 1
                Dim row As New List(Of Cell)
                For x As Integer = 0 To width - 1
                    Dim lx As Integer = Logic.Hexmap.LeftIndex(y) + x
                    Dim ly As Integer = y
                    Dim points() As Point = GetHexCellPoints(x, y)
                    Dim nowcell As New Cell(Me, lx, ly, points)
                    row.Add(nowcell)
                Next
                _cells.Add(row)
            Next
        End Sub

        Private Function GetHexCellPoints(ByVal x As Integer, ByVal y As Integer) As Point()
            Dim WScale As Integer = CInt(1.73 * HexScale / 2)
            Dim HScale As Integer = CInt(0.5 * HexScale)

            Dim chipTop As Integer = HScale * 3 * y
            Dim chipleft As Integer
            If y Mod 2 = 0 Then
                chipleft = WScale * 2 * x
            Else
                chipleft = WScale * 2 * x + WScale
            End If

            Dim ps As Point() = {
               New Point(chipleft + WScale, chipTop),
               New Point(chipleft, chipTop + HScale),
               New Point(chipleft, chipTop + 3 * HScale),
               New Point(chipleft + WScale, chipTop + 4 * HScale),
               New Point(chipleft + WScale * 2, chipTop + 3 * HScale),
               New Point(chipleft + WScale * 2, chipTop + HScale)}
            Return ps
        End Function

    End Class

End Namespace

