﻿Namespace Logic
    Public Class Hexmap
        Private _directionX As Integer() = {0, 1, -1, 1, -1, 0}
        Private _directionY As Integer() = {-1, -1, 0, 0, 1, 1}

        ''' <summary>
        ''' 移動可能領域
        ''' </summary>
        ''' <param name="srcX"></param>
        ''' <param name="srcY"></param>
        ''' <param name="movality"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function GetMovableCell(ByVal srcX As Integer, ByVal srcY As Integer, ByVal movality As Integer) As ICollection(Of MovalityCell)
            Dim searchList As New List(Of MovalityCell)
            searchList.Add(New MovalityCell(Cell(srcX, srcY), movality))
            Dim completeList As New List(Of MovalityCell)
            While 0 < searchList.Count
                Dim fromX As Integer = searchList(0).X
                Dim fromY As Integer = searchList(0).Y
                Dim fromMovality As Integer = searchList(0).Movality
                For i As Integer = 0 To _directionX.Length - 1
                    Dim toX As Integer = fromX + _directionX(i)
                    Dim toY As Integer = fromY + _directionY(i)
                    Dim toMovality As Integer = fromMovality - Cell(toX, toY).FieldMovePoint
                    If 0 < toMovality Then
                        searchList.Add(New MovalityCell(Cell(toX, toY), movality))
                    End If
                    completeList.Add(searchList(0))
                    searchList.RemoveAt(0)
                Next
            End While
            'todo:正しく実装。
            Return completeList
        End Function

        Public Sub New(ByVal width As Integer, ByVal height As Integer)
            _width = width
            _height = height
            ReDim _cellArray(_width * _height - 1)
            For y As Integer = 0 To height - 1
                For x As Integer = LeftIndex(y) To width + LeftIndex(y) - 1
                    _cellArray(arrayIndex(x, y)) = New Cell(x, y)
                Next
            Next

        End Sub
        Private _width As Integer
        Private _height As Integer
        Public ReadOnly Property Width As Integer
            Get
                Return _width
            End Get
        End Property
        Public ReadOnly Property Height As Integer
            Get
                Return _height
            End Get
        End Property

        Private _cellArray() As Cell

        ''' <summary>
        ''' 一番右のインデックスの値を返す。
        ''' </summary>
        ''' <param name="row">行</param>
        ''' <returns></returns>
        ''' <remarks>
        ''' 一番右上は(0,0)で始まるが、下に行くと(0,1)、(-1,2),(-1,3),(-2,4)から始まる</remarks>
        Public Shared Function LeftIndex(ByVal row As Integer) As Integer
            Return -row \ 2
        End Function


        Public Function ValidPosition(ByVal x As Integer, ByVal y As Integer) As Boolean
            Return 0 <= y AndAlso y < _height AndAlso
                 LeftIndex(y) <= x AndAlso x < LeftIndex(y) + _width
        End Function

        Public Property Cell(ByVal x As Integer, ByVal y As Integer) As Cell
            Get
                Return _cellArray(arrayIndex(x, y))
            End Get
            Set(value As Cell)
                _cellArray((arrayIndex(x, y))) = value
            End Set
        End Property

        Private Function arrayIndex(ByVal x As Integer, ByVal y As Integer) As Integer
            Dim col As Integer = x
            If x < 0 Then
                col = _width + x
            End If
            Dim row As Integer = y
            Return y * _width + col
        End Function

        Sub Clear()
            For Each v As Cell In _cellArray
                v.FieldInstance = Field.GetFieldInstance(Field.TypeEnum.UNKNOWN)
            Next
        End Sub

    End Class

End Namespace
