﻿Namespace Logic

    Public Class Field
        Public Enum TypeEnum
            ''' <summary>
            ''' 草原
            ''' </summary>
            ''' <remarks></remarks>
            Grassland
            ''' <summary>
            ''' 森
            ''' </summary>
            ''' <remarks></remarks>
            Forest
            ''' <summary>
            ''' 道
            ''' </summary>
            ''' <remarks></remarks>
            Road
            ''' <summary>
            ''' 味方住居
            ''' </summary>
            ''' <remarks></remarks>
            PlayerHouse
            ''' <summary>
            ''' 海
            ''' </summary>
            ''' <remarks></remarks>
            Sea
            ''' <summary>
            ''' 川
            ''' </summary>
            ''' <remarks></remarks>
            River
            ''' <summary>
            ''' 城壁
            ''' </summary>
            ''' <remarks></remarks>
            Wall
            ''' <summary>
            ''' 城道
            ''' </summary>
            ''' <remarks></remarks>
            Castle
            ''' <summary>
            ''' 城門
            ''' </summary>
            ''' <remarks></remarks>
            Gate
            ''' <summary>
            ''' 山
            ''' </summary>
            ''' <remarks></remarks>
            Mountain
            ''' <summary>
            ''' 敵家住居
            ''' </summary>
            ''' <remarks></remarks>
            EnemyHouse
            ''' <summary>
            ''' 味方陣地
            ''' </summary>
            ''' <remarks></remarks>
            PlayerCamp
            ''' <summary>
            ''' 敵陣地
            ''' </summary>
            ''' <remarks></remarks>
            EnemyCamp
            ''' <summary>
            ''' ゴール
            ''' </summary>
            ''' <remarks></remarks>
            Goal
            ''' <summary>
            ''' 不明
            ''' </summary>
            ''' <remarks></remarks>
            UNKNOWN
        End Enum

        Private Sub New()
        End Sub

        Private Sub New(ByVal type As TypeEnum)
            _type = type
            _dataChar = FieldTypeToDataChar(type)
        End Sub

        Private Shared _instanceList(DirectCast(TypeEnum.UNKNOWN, Integer)) As Field
        Shared Sub New()
            For i As Integer = TypeEnum.Grassland To TypeEnum.UNKNOWN
                _instanceList(i) = New Field(DirectCast(i, TypeEnum))
            Next
        End Sub

        Public Shared Function GetFieldInstance(ByVal fieldType As TypeEnum) As Field
            Return _instanceList(DirectCast(fieldType, Integer))
        End Function

        Public Shared Function GetFieldInstance(ByVal fieldDataChar As String) As Field
            Return GetFieldInstance(DataCharToFieldType(fieldDataChar))
        End Function

        Private _type As TypeEnum
        Public ReadOnly Property Type As TypeEnum
            Get
                Return _type
            End Get
        End Property

        Private _dataChar As String
        Public ReadOnly Property DataChar As String
            Get
                Return _dataChar
            End Get
        End Property



        Private Shared _fieldDataChar() As String = {"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "UNKNOWN"}
        Public Shared Function DataCharToFieldType(ByVal datachar As String) As TypeEnum
            For i As Integer = 0 To _fieldDataChar.Length - 1
                If _fieldDataChar(i) = datachar Then
                    Return DirectCast(i, TypeEnum)
                End If
            Next
            Debug.Assert(False)
            Return TypeEnum.UNKNOWN
        End Function

        Public Shared Function FieldTypeToDataChar(ByVal fieldtype As TypeEnum) As String
            Return _fieldDataChar(DirectCast(fieldtype, Integer))
        End Function


        Private Shared _FieldMovePoint() As Integer = {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}
        ''' <summary>
        ''' 移動阻害値
        ''' </summary>
        ''' <remarks></remarks>
        Public Shared Function GetFieldMovePoint(ByVal type As TypeEnum) As Integer
            Return _FieldMovePoint(DirectCast(type, Integer))
        End Function

        Public ReadOnly Property MovePoint As Integer
            Get
                Return GetFieldMovePoint(Me.Type)
            End Get
        End Property

        Private Shared _fieldDetectPoint() As Integer = {2, 5, 2, 3, 2, 2, 2, 4, 2, 5, 3, 3, 3, 3, 0}
        ''' <summary>
        ''' 視界阻害値
        ''' </summary>
        ''' <param name="type"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Private Shared Function GetFieldDetectPoint(ByVal type As TypeEnum) As Integer
            Return _fieldDetectPoint(DirectCast(type, Integer))
        End Function

        Public ReadOnly Property DetectPoint As Integer
            Get
                Return GetFieldDetectPoint(Me.Type)
            End Get
        End Property

    End Class

End Namespace

