﻿Imports System.Text
Imports Microsoft.VisualStudio.TestTools.UnitTesting
Namespace Logic

    <TestClass()> Public Class SkillLevelTest

        <TestMethod()> Public Sub SpeedSkillTest()
            Dim playerSide As Side = Side.GetPlayerSide
            playerSide.Money = 10
            Dim SpeedSkill As SkillLevel = playerSide.Speed
            Assert.AreEqual(0, SpeedSkill.Level)
            Assert.AreEqual(0, SpeedSkill.LevelValue)
            Assert.AreEqual(False, SpeedSkill.CanLevelUp)
            Assert.AreEqual(False, SpeedSkill.IsMaxLevel)
            playerSide.Money = 2000
            Assert.AreEqual(True, SpeedSkill.CanLevelUp)
            SpeedSkill.LevelUp()
            Assert.AreEqual(1950, playerSide.Money)
            Assert.AreEqual(1, SpeedSkill.Level)
            Assert.AreEqual(1, SpeedSkill.LevelValue)
            Assert.AreEqual(False, SpeedSkill.IsMaxLevel)
            Assert.AreEqual(True, SpeedSkill.CanLevelUp)
            SpeedSkill.LevelUp()
            Assert.AreEqual(1850, playerSide.Money)
            Assert.AreEqual(2, SpeedSkill.Level)
            Assert.AreEqual(False, SpeedSkill.IsMaxLevel)
            Assert.AreEqual(True, SpeedSkill.CanLevelUp)
            SpeedSkill.LevelUp()
            Assert.AreEqual(1650, playerSide.Money)
            Assert.AreEqual(3, SpeedSkill.Level)
            Assert.AreEqual(False, SpeedSkill.IsMaxLevel)
            Assert.AreEqual(True, SpeedSkill.CanLevelUp)
            SpeedSkill.LevelUp()
            Assert.AreEqual(1350, playerSide.Money)
            Assert.AreEqual(4, SpeedSkill.Level)
            Assert.AreEqual(True, SpeedSkill.IsMaxLevel)
            Assert.AreEqual(False, SpeedSkill.CanLevelUp)
            Assert.AreEqual(4, SpeedSkill.LevelValue)
        End Sub

    End Class
End Namespace
