﻿Imports System.Text
Imports Microsoft.VisualStudio.TestTools.UnitTesting
Namespace Logic

    <TestClass()> Public Class SideTest

        <TestMethod()> Public Sub PlattonNameTest()
            Dim playerSide As Side = Side.GetPlayerSide
            Dim platoonUnit As New PlatoonUnit
            platoonUnit.Level = 0
            platoonUnit.UnitType = Logic.PlatoonUnit.UnitTypeEnum.Patrol
            Assert.AreEqual("物見", playerSide.PlattonName(platoonUnit))
        End Sub

        <TestMethod()> Public Sub PlattonCostTest()
            Dim playerSide As Side = Side.GetPlayerSide
            Dim platoonUnit As New PlatoonUnit
            platoonUnit.Level = 2
            platoonUnit.UnitType = Logic.PlatoonUnit.UnitTypeEnum.Artillery
            Assert.AreEqual(55, playerSide.PlattonCost(platoonUnit))
        End Sub

        <TestMethod()> Public Sub RangeLevelUpTest()
            Dim playerSide As Side = Side.GetPlayerSide
            playerSide.Money = 100
            Assert.AreEqual(0, playerSide.Range.Level)
            Assert.AreEqual(False, playerSide.Range.CanLevelUp)
            Assert.AreEqual(False, playerSide.Range.IsMaxLevel)
            playerSide.Money = 1000
            Assert.AreEqual(True, playerSide.Range.CanLevelUp)
            playerSide.Range.LevelUp()
            Assert.AreEqual(800, playerSide.Money)
            Assert.AreEqual(1, playerSide.Range.Level)
            Assert.AreEqual(False, playerSide.Range.IsMaxLevel)
            Assert.AreEqual(True, playerSide.Range.CanLevelUp)
            playerSide.Range.LevelUp()
            Assert.AreEqual(300, playerSide.Money)
            Assert.AreEqual(2, playerSide.Range.Level)
            Assert.AreEqual(True, playerSide.Range.IsMaxLevel)
            Assert.AreEqual(False, playerSide.Range.CanLevelUp)
        End Sub
    End Class
End Namespace
