﻿Imports System.Text
Imports Microsoft.VisualStudio.TestTools.UnitTesting

Namespace Logic
    <TestClass()> Public Class BattalionUnitTest

        <TestMethod()> Public Sub RangeStringTest()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            Dim pUnit1 As New PlatoonUnit
            pUnit1.RangeMax = 1
            pUnit1.RangeMin = 1
            bUnit.AddPlatoonUnit(pUnit1)
            Assert.AreEqual("1", bUnit.RangeString)
            Dim pUnit2 As New PlatoonUnit
            pUnit2.RangeMax = 5
            pUnit2.RangeMin = 2
            bUnit.AddPlatoonUnit(pUnit2)
            Assert.AreEqual("1‐5", bUnit.RangeString)

        End Sub

        <TestMethod()> Public Sub RangeMinMaxTest()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            Dim pUnit1 As New PlatoonUnit
            pUnit1.RangeMax = 1
            pUnit1.RangeMin = 1
            bUnit.AddPlatoonUnit(pUnit1)
            Dim pUnit2 As New PlatoonUnit
            pUnit2.RangeMax = 5
            pUnit2.RangeMin = 2
            bUnit.AddPlatoonUnit(pUnit2)
            Assert.AreEqual(1, bUnit.RangeMin)
            Assert.AreEqual(5, bUnit.RangeMax)
        End Sub

        <TestMethod()> Public Sub SetToTest()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            Dim map As New Hexmap(10, 10)
            bUnit.SetTo(map, -1, 5)
            Assert.AreEqual(bUnit, map.Cell(-1, 5).Unit)
            Assert.AreEqual(-1, bUnit.x)
            Assert.AreEqual(5, bUnit.y)
        End Sub

        <TestMethod()> Public Sub MoveToTest()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            Dim map As New Hexmap(10, 10)
            bUnit.SetTo(map, -1, 5)
            Assert.AreEqual(False, map.Cell(-1, 5).UnitIsNotExist)
            bUnit.MoveTo(-2, 6)
            Assert.AreEqual(True, map.Cell(-1, 5).UnitIsNotExist)
            Assert.AreEqual(bUnit, map.Cell(-2, 6).Unit)
            Assert.AreEqual(-2, bUnit.x)
            Assert.AreEqual(6, bUnit.y)
        End Sub

        <TestMethod()> Public Sub CostTest()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            bUnit.Side = Side.GetPlayerSide
            Dim pUnit1 As New PlatoonUnit
            pUnit1.Cost = 10
            Dim pUnit2 As New PlatoonUnit
            pUnit2.Cost = 35
            bUnit.AddPlatoonUnit(pUnit1)
            bUnit.AddPlatoonUnit(pUnit2)
            Assert.AreEqual(45, bUnit.Cost)

        End Sub

        <TestMethod()> Public Sub PlatoonImplCostTest()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            bUnit.Side = Side.GetPlayerSide
            Dim pUnit1 As New PlatoonUnitImpl(Side.GetPlayerSide, PlatoonUnit.UnitTypeEnum.Patrol, 0)
            Assert.AreEqual(10, pUnit1.Cost)
            Dim pUnit2 As New PlatoonUnitImpl(Side.GetPlayerSide, PlatoonUnit.UnitTypeEnum.Artillery, 1)
            Assert.AreEqual(35, pUnit2.Cost)
            bUnit.AddPlatoonUnit(pUnit1)
            bUnit.AddPlatoonUnit(pUnit2)
            Assert.AreEqual(45, bUnit.Cost)

        End Sub

        <TestMethod()> Public Sub IsConfused1Test()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            Assert.AreEqual(False, bUnit.IsConfused)
            bUnit.PlattonUnits(0).Hp -= 10
            Assert.AreEqual(False, bUnit.IsConfused)
            bUnit.PlattonUnits(1).Hp -= 10
            Assert.AreEqual(True, bUnit.IsConfused)
        End Sub

        <TestMethod()> Public Sub IsConfused2Test()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.PlattonUnits(0).Hp -= 10
            bUnit.PlattonUnits(1).Hp -= 10
            Assert.AreEqual(False, bUnit.IsConfused)
            bUnit.PlattonUnits(2).Hp -= 10
            Assert.AreEqual(True, bUnit.IsConfused)
        End Sub

        <TestMethod()> Public Sub IsConfused3Test()
            Dim bUnit As New BattalionUnit(Side.GetPlayerSide)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.AddPlatoonUnit(New PlatoonUnit)
            bUnit.PlattonUnits(0).Hp -= 20
            bUnit.PlattonUnits(1).Hp -= 10
            Assert.AreEqual(False, bUnit.IsConfused)
            bUnit.PlattonUnits(2).Hp -= 10
            Assert.AreEqual(False, bUnit.IsConfused)
            bUnit.PlattonUnits(3).Hp -= 10
            Assert.AreEqual(True, bUnit.IsConfused)
        End Sub

        <TestMethod()> Public Sub SpeedTest()
            Dim bUnit1 As New BattalionUnit(Side.GetPlayerSide)
            Dim p1_1 As New PlatoonUnit
            p1_1.Speed = 9
            bUnit1.AddPlatoonUnit(p1_1)
            Assert.AreEqual(9, bUnit1.Speed)
            Dim p1_2 As New PlatoonUnit
            p1_2.Speed = 10
            bUnit1.AddPlatoonUnit(p1_2)
            Assert.AreEqual(10, bUnit1.Speed)

            Dim bUnit2 As New BattalionUnit(Side.GetPlayerSide)
            Dim p2_1 As New PlatoonUnit
            p2_1.Speed = 15
            bUnit2.AddPlatoonUnit(p2_1)
            Dim p2_2 As New PlatoonUnit
            p2_2.Speed = 8
            bUnit2.AddPlatoonUnit(p2_2)
            Dim p2_3 As New PlatoonUnit
            p2_3.Speed = 8
            bUnit2.AddPlatoonUnit(p2_3)
            Dim p2_4 As New PlatoonUnit
            p2_4.Speed = 8
            bUnit2.AddPlatoonUnit(p2_4)
            Dim p2_5 As New PlatoonUnit
            p2_5.Speed = 8
            bUnit2.AddPlatoonUnit(p2_5)
            Assert.AreEqual(10, bUnit2.Speed)


        End Sub

    End Class
End Namespace
