﻿Imports Ryaku101.Common.Logic

Public Class frmMakeFormation

    Public Property PlayerSide As Side = Side.GetPlayerSide

    Private Sub btnSpeedUp_Click(sender As Object, e As EventArgs) Handles btnSpeedUp.Click
        PlayerSide.Speed.LevelUp()
        UpdateUI()
    End Sub

    Private Sub btnQuickUp_Click(sender As Object, e As EventArgs) Handles btnQuickUp.Click
        PlayerSide.Quick.LevelUp()
        UpdateUI()
    End Sub

    Private Sub btnDetectUp_Click(sender As Object, e As EventArgs) Handles btnDetectUp.Click
        PlayerSide.Detect.LevelUp()
        UpdateUI()
    End Sub
    Private Sub btnRangeUp_Click(sender As Object, e As EventArgs) Handles btnRangeUp.Click
        PlayerSide.Range.LevelUp()
        UpdateUI()
    End Sub
    Private Sub btnIndirectDefence_Click(sender As Object, e As EventArgs) Handles btnIndirectDefenceUp.Click
        PlayerSide.IndirectDefence.LevelUp()
        UpdateUI()
    End Sub
    Private Sub btnDirectDefenceUp_Click(sender As Object, e As EventArgs) Handles btnDirectDefenceUp.Click
        PlayerSide.DirectDefence.LevelUp()
        UpdateUI()
    End Sub

    Private Sub btnAttackUp_Click(sender As Object, e As EventArgs) Handles btnAttackUp.Click
        PlayerSide.Attack.LevelUp()
        UpdateUI()
    End Sub

    Private Sub UpdateUI()
        UpdateUIPlatoonUnitButtons()
        UpdateSkills()
        lblMoney.Text = String.Format("{0}", PlayerSide.Money)
        lstBattalionUnit.DataSource = Nothing
        If SelectedBattalionUnit Is Nothing Then
            lblUnitNumber.Text = "部隊が選択されていません。"
        Else
            lstBattalionUnit.DataSource = SelectedBattalionUnit.PlattonUnits
            lblUnitNumber.Text = String.Format("第{0}部隊", SelectedBattalionUnit.Number)
        End If
        lstRegiment.DataSource = Nothing
        lstRegiment.DataSource = Regiment.BattalionUnits
    End Sub

    Private Sub UpdateSkills()
        UpdateUISkillButton(PlayerSide.Speed, btnSpeedUp, lblSpeed)
        UpdateUISkillButton(PlayerSide.Quick, btnQuickUp, lblQuick)
        UpdateUISkillButton(PlayerSide.Detect, btnDetectUp, lblDetect)
        UpdateUISkillButton(PlayerSide.Range, btnRangeUp, lblRange)
        UpdateUISkillButton(PlayerSide.IndirectDefence, btnIndirectDefenceUp, lblIndirectDefence)
        UpdateUISkillButton(PlayerSide.DirectDefence, btnDirectDefenceUp, lblDirectDefence)
        UpdateUISkillButton(PlayerSide.Attack, btnAttackUp, lblAttack)
    End Sub


    Private Sub UpdateUISkillButton(ByVal skill As SkillLevel, ByVal btn As Button, ByVal lbl As Label)
        lbl.Text = String.Format("現在はレベル{0}", skill.Level)
        If skill.IsMaxLevel Then
            btn.Text = "上限のレベルに達しています。"
            btn.Enabled = False
        ElseIf Not skill.CanLevelUp Then
            btn.Text = "資金が足りません。"
            btn.Enabled = False
        Else
            btn.Text = String.Format("レベル{0}へは ${1}", skill.Level + 1, skill.NextLevelCost)
            btn.Enabled = True
        End If

    End Sub
    Private btnPlatoonUnits As Button()()

    Private Sub SetbtnPlatoonUnits()
        SetbtnPlattonUnitsArray()
        SetbtnPlattonUnitsAddHandeler()
    End Sub

    Private Sub SetbtnPlattonUnitsArray()
        btnPlatoonUnits = {
            New Button() {btnInfantry1, btnInfantry2, btnInfantry3, btnInfantry4},
            New Button() {btnArcher1, btnArcher2, btnArcher3, btnArcher4},
            New Button() {btnKnight1, btnKnight2, btnKnight3, btnKnight4},
            New Button() {btnMagician1, btnMagician2, btnMagician3, btnMagician4},
            New Button() {btnArtillery1, btnArtillery2, btnArtillery3, btnArtillery4},
            New Button() {btnPatrol1, btnPatrol2, btnPatrol3}
            }
    End Sub

    Private Sub SetbtnPlattonUnitsAddHandeler()
        For Each buttons As Button() In btnPlatoonUnits
            For Each btn As Button In buttons
                AddHandler btn.Click, AddressOf btnPlatoonUnit_Click
            Next
        Next
    End Sub

    Private Sub UpdateUIPlatoonUnitButtons()
        Debug.Assert(btnPlatoonUnits.Length = PlatoonUnit.UnitTypeEnum.Patrol + 1)
        For i As PlatoonUnit.UnitTypeEnum = 0 To PlatoonUnit.UnitTypeEnum.Patrol
            For level As Integer = 0 To btnPlatoonUnits(i).Length - 1
                UpdateUIPlatoonUnitButton(btnPlatoonUnits(i)(level), i, level)
            Next
        Next
    End Sub

    Private Sub UpdateUIPlatoonUnitButton(ByVal btn As Button, ByVal unittype As PlatoonUnit.UnitTypeEnum, ByVal level As Integer)
        Dim platoonUnit As PlatoonUnit = GetPlayerPlattonUnit(unittype, level)
        btn.Text = String.Format("{0} ${1}", platoonUnit.Name, platoonUnit.Cost)
        If PlayerSide.Money < platoonUnit.Cost Then
            btn.Enabled = False
        Else
            btn.Enabled = True
        End If
    End Sub

    Private Function GetPlattonUnitByButton(ByVal btn As Button) As PlatoonUnit
        Debug.Assert(btnPlatoonUnits.Length = PlatoonUnit.UnitTypeEnum.Patrol + 1)
        For i As PlatoonUnit.UnitTypeEnum = 0 To PlatoonUnit.UnitTypeEnum.Patrol
            For level As Integer = 0 To btnPlatoonUnits(i).Length - 1
                If btn Is btnPlatoonUnits(i)(level) Then
                    Return GetPlayerPlattonUnit(i, level)
                End If
            Next
        Next
        Debug.Assert(False)
        Return Nothing
    End Function

    Private Function GetPlayerPlattonUnit(ByVal unittype As PlatoonUnit.UnitTypeEnum, ByVal level As Integer) As PlatoonUnit
        Dim platoonUnit As New PlatoonUnitImpl(PlayerSide, unittype, level)
        Return platoonUnit
    End Function


    Private Sub frmMakeFormation_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        SetbtnPlatoonUnits()
        UpdateUI()

    End Sub

    Private SelectedBattalionUnit As BattalionUnit
    Private Regiment As New Regiment(PlayerSide)

    Private Sub btnPlatoonUnit_Click(sender As Object, e As EventArgs)
        If SelectedBattalionUnit Is Nothing Then
            If Not Regiment.CanAddUnit Then
                MessageBox.Show("これ以上この部隊を追加することはできません。")
                Exit Sub
            Else
                SelectedBattalionUnit = Regiment.CreateNewBattalionUnit()
            End If
        End If
        If Not SelectedBattalionUnit.CanAddUnit Then
            MessageBox.Show("これ以上この部隊に小隊を追加することはできません。")
            Exit Sub
        End If

        Dim unit As PlatoonUnit = GetPlattonUnitByButton(DirectCast(sender, Button))
        SelectedBattalionUnit.AddPlatoonUnit(unit)
        UpdateUI()

    End Sub


    Private Sub lstRegiment_DrawItem(sender As Object, e As DrawItemEventArgs) Handles lstRegiment.DrawItem

        e.DrawBackground()
        'ListBoxが空のときに
        If e.Index <= -1 Then
            Exit Sub
        End If


        '描画する文字列の取得
        Dim bUnit As BattalionUnit = DirectCast(lstRegiment.Items(e.Index), BattalionUnit)
        Dim txt As String = String.Empty
        For i As Integer = 0 To bUnit.PlattonUnits.Count - 1
            Dim punit As PlatoonUnit = bUnit.PlattonUnits(i)
            txt = punit.UnitTypeName
            Dim color As Color = UI.SettingReader.GetColorOfUnitLevel(punit.Level)
            Dim b As Brush = New SolidBrush(color)
            e.Graphics.DrawString(txt, e.Font, b, e.Bounds.X + i * 20, e.Bounds.Y)
            b.Dispose()
        Next



    End Sub

    Private Sub lstBattalionUnit_DrawItem(sender As Object, e As DrawItemEventArgs) Handles lstBattalionUnit.DrawItem

        'ListBoxが空のときに
        If e.Index <= -1 Then
            Exit Sub
        End If

        Dim punit As PlatoonUnit = DirectCast(lstBattalionUnit.Items(e.Index), PlatoonUnit)
        If punit Is Nothing Then
            Exit Sub
        End If

        Dim color As Color = UI.SettingReader.GetColorOfUnitLevel(punit.Level)
        Dim b As Brush = New SolidBrush(color)
        e.Graphics.DrawString(punit.Name, e.Font, b, e.Bounds.X, e.Bounds.Y)

        b.Dispose()

    End Sub


    Private Sub btnClear_Click(sender As Object, e As EventArgs) Handles btnClear.Click
        If SelectedBattalionUnit Is Nothing Then
            Exit Sub
        End If
        SelectedBattalionUnit.UnitClear()
        UpdateUI()
    End Sub

    Private Sub btnEditEnd_Click(sender As Object, e As EventArgs) Handles btnEditEnd.Click
        Dim editedUnit As BattalionUnit = SelectedBattalionUnit

        If lstRegiment.SelectedIndex = lstRegiment.Items.Count - 1 Then
            lstRegiment.SelectedIndex = -1
        Else
            lstRegiment.SelectedIndex += 1
        End If

        UpdateUI()
        While Regiment.CanAddUnit AndAlso
                editedUnit IsNot Nothing AndAlso
                editedUnit.Cost <= PlayerSide.Money
            Dim retAns As Windows.Forms.DialogResult = MessageBox.Show("同じ部隊を作りますか？", "同部隊作成確認", MessageBoxButtons.YesNo)
            If retAns = Windows.Forms.DialogResult.Yes Then
                SelectedBattalionUnit = GetCloneOfBattalionUnit(editedUnit)
                UpdateUI()
            Else
                Exit Sub
            End If
        End While
        UpdateUI()
    End Sub

    Private Function GetCloneOfBattalionUnit(ByVal sourceUnit As BattalionUnit) As BattalionUnit
        Dim destUnit As BattalionUnit = Regiment.CreateNewBattalionUnit()
        For Each punit As PlatoonUnit In sourceUnit.PlattonUnits
            Dim pdestunit As New PlatoonUnit(punit)
            destUnit.AddPlatoonUnit(pdestunit)
        Next
        Debug.Assert(sourceUnit.Cost = destUnit.Cost)
        Return destUnit
    End Function


    Private Sub lstRegiment_SelectedIndexChanged(sender As Object, e As EventArgs) Handles lstRegiment.SelectedIndexChanged
        lstBattalionUnit.DataSource = Nothing
        If lstRegiment.SelectedIndex = -1 Then
            SelectedBattalionUnit = Nothing
        Else
            SelectedBattalionUnit = DirectCast(lstRegiment.SelectedItem, BattalionUnit)
            lstBattalionUnit.DataSource = SelectedBattalionUnit.PlattonUnits
        End If

    End Sub


    Private Sub btnGameStart_Click(sender As Object, e As EventArgs) Handles btnGameStart.Click
        If Regiment.BattalionUnits.Count = 0 Then
            MessageBox.Show("部隊が存在しません。一つ以上の部隊を作成してください。")
            Exit Sub
        End If

        If Not IsContinueButPlatoonCanBuy() Then
            Exit Sub
        End If

        Me.Close()
    End Sub

    Private Function IsContinueButPlatoonCanBuy() As Boolean
        For Each btns As Button() In btnPlatoonUnits
            For Each btn As Button In btns
                If btn.Enabled Then
                    Dim retAns As Windows.Forms.DialogResult = MessageBox.Show("まだ小隊が購入できますがこのままスタートしますか", "小隊購入確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question)
                    If retAns = Windows.Forms.DialogResult.No Then
                        Return False
                    Else
                        Return True
                    End If
                End If
            Next
        Next
        Return True
    End Function
End Class