﻿Imports Ryaku101.Common.Logic
Imports Ryaku101.UI
Imports Ryaku101.UI.Form.frmBattle

Public Class frmBattle

    Public Property TargetUnit As BattalionUnit
    Public Property AttackerUnit As BattalionUnit





    Private Sub frmBattle_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Debug.Assert(AttackerUnit IsNot Nothing)
        Debug.Assert(TargetUnit IsNot Nothing)
        Debug.Assert(0 < AttackerUnit.PlattonUnits.Count)
        Debug.Assert(0 < TargetUnit.PlattonUnits.Count)
        SetAttackButton(AttackerUnit.PlattonUnits(0))
        UnitToForm()
    End Sub

    Private Sub SetAttackButton(ByVal attackpUnit As PlatoonUnit)
        Dim isAll As Boolean = False
        If attackpUnit.UnitType = PlatoonUnit.UnitTypeEnum.Magician Then
            isAll = True
        End If
        btnAttackToTargetUnit1.Visible = Not isAll
        btnAttackToTargetUnit2.Visible = Not isAll
        btnAttackToTargetUnit3.Visible = Not isAll
        btnAttackToTargetUnit4.Visible = Not isAll
        btnAttackToTargetUnit5.Visible = Not isAll
        btnAttackToAllTarget.Visible = isAll
    End Sub

    Private Sub UnitToForm()
        TargetUnitToForm()
        AttackUnitToForm()
    End Sub

    Private Sub AttackUnitToForm()

        AttackerSkillLevel.Disp(AttackerUnit.Side)
        lblAttackerName.Text = AttackerUnit.Name
        lblAttackerCommander.Text = GetCommanderText(AttackerUnit.Side)

        Dim attackerUnitControls As platoonUnitDisper() = {
            AttackerUnit1,
            AttackerUnit2,
            AttackerUnit3,
            AttackerUnit4,
            AttackerUnit5}
        Dim pActs As List(Of PlatoonAction) = GetPUnitActions(AttackerUnit)
        For i As Integer = 0 To attackerUnitControls.Count - 1
            Dim pAct As PlatoonAction = pActs(i)
            attackerUnitControls(i).disp(pAct)
        Next


    End Sub

    Private Sub TargetUnitToForm()

        TargetSkillLevel.Disp(TargetUnit.Side)
        lblTargetName.Text = TargetUnit.Name
        lblTargetCommander.Text = GetCommanderText(TargetUnit.Side)

        Dim targetUnitControls As platoonUnitDisper() = {
            TargetUnit1,
            TargetUnit2,
            TargetUnit3,
            TargetUnit4,
            TargetUnit5}
        Dim pActs As List(Of PlatoonAction) = GetPUnitActions(TargetUnit)
        For i As Integer = 0 To targetUnitControls.Count - 1
            Dim pAct As PlatoonAction = pActs(i)
            targetUnitControls(i).disp(pAct)
        Next
    End Sub

    Private Function GetPUnitActions(battalionUnit As BattalionUnit) As List(Of PlatoonAction)
        Dim pActs As New List(Of PlatoonAction)

        For i As Integer = 0 To battalionUnit.MaxUnitCount - 1
            Dim pAct As New PlatoonAction
            If i < battalionUnit.PlattonUnits.Count Then
                Dim punit As PlatoonUnit = battalionUnit.PlattonUnits(i)
                pAct.PlatoonUnit = punit
            End If
            pAct.IsActionEnd = False 'todo:値セット
            pAct.IsActive = False 'todo:値セット
            pActs.Add(pAct)
        Next
        Return pActs
    End Function






    Private Function GetCommanderText(ByVal side As Side) As String
        Return String.Format("指揮官 {0}", side.CommanderName)
    End Function


End Class