﻿Namespace Utils


    Public Class HexMapUtil

        ''' <summary>
        ''' ファイルからヘックスマップを作成。
        ''' </summary>
        ''' <param name="filename"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function OpenFile(ByVal filename As String) As Logic.Hexmap

            Dim lines As List(Of String) = GetLines(filename)
            Dim m As Logic.Hexmap = LinesToHexMap(lines)
            Return m

        End Function

        Private Shared Function GetLines(ByVal filename As String) As List(Of String)
            Dim lines As New List(Of String)

            Using fs As New System.IO.StreamReader(filename)
                While Not fs.EndOfStream
                    Dim line As String = fs.ReadLine()
                    lines.Add(line)
                    Debug.Assert(lines(0).Length = line.Length)
                    If lines(0).Length <> line.Length Then
                        Exit While
                    End If
                End While
            End Using
            Return lines
        End Function

        Private Shared Function LinesToHexMap(ByVal lines As List(Of String)) As Logic.Hexmap
            Dim m As New Logic.Hexmap(lines(0).Length, lines.Count)
            For y As Integer = 0 To lines.Count - 1
                Dim x As Integer = Logic.Hexmap.LeftIndex(y)
                For i As Integer = 0 To lines(y).Length - 1
                    m.Cell(x, y).FieldInstance = Logic.Field.GetFieldInstance(lines(y)(i))
                    x += 1
                Next
            Next
            Return m
        End Function

    End Class

End Namespace