﻿Namespace Logic

    ''' <summary>
    ''' 技術レベル
    ''' </summary>
    ''' <remarks></remarks>
    Public Class SkillLevel

        ''' <summary>
        ''' 素早さの技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetQuickSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {100, 250, 500}
            s._levelValues = New Integer() {0, 1, 2, 3}
            Return s
        End Function

        ''' <summary>
        ''' 機動力の技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetSpeedSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {50, 100, 200, 300}
            s._levelValues = New Integer() {0, 1, 2, 3, 4}
            Return s
        End Function

        ''' <summary>
        ''' 攻撃力の技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetAttackSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {50, 100, 200, 300}
            s._levelValues = New Integer() {0, 1, 2, 3, 4}
            Return s
        End Function

        ''' <summary>
        ''' 直接防御の技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetDirectDefenceSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {50, 100, 200, 300}
            s._levelValues = New Integer() {0, 1, 2, 3, 4}
            Return s
        End Function

        ''' <summary>
        ''' 間接防御の技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetInDirectDefenceSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {50, 100, 200, 300}
            s._levelValues = New Integer() {0, 1, 2, 3, 4}
            Return s
        End Function

        ''' <summary>
        ''' 射程距離の技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetRangeSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {200, 500}
            s._levelValues = New Integer() {0, 1, 2}
            Return s
        End Function

        ''' <summary>
        ''' 索敵能力の技術レベル
        ''' </summary>
        ''' <param name="side"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetDetectSkillLevel(ByVal side As Side) As SkillLevel
            Dim s As New SkillLevel(side)
            s._levelUpCosts = New Integer() {50, 100, 200, 300}
            s._levelValues = New Integer() {0, 1, 2, 3, 4}
            Return s
        End Function

        Private _side As Side
        Public Sub New(ByVal side As Side)
            _side = side
        End Sub

        Private _level As Integer = 0
        ''' <summary>
        ''' 技術レベル
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks>
        ''' </remarks>
        Public ReadOnly Property Level As Integer
            Get
                Return _level
            End Get
        End Property
        ''' <summary>
        ''' レベル補正値
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks>実際の攻撃力や防御力、射程距離の補正値</remarks>
        Public ReadOnly Property LevelValue As Integer
            Get
                Return _levelValues(_level)
            End Get
        End Property

        Private _levelValues() As Integer
        Private _levelUpCosts() As Integer

        ''' <summary>
        ''' レベルアップが可能か
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function CanLevelUp() As Boolean
            If IsMaxLevel() Then
                Return False
            End If
            If Money <= _levelUpCosts(_level) Then
                Return False
            End If
            Return True
        End Function

        ''' <summary>
        ''' レベルが最大に達しているか
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function IsMaxLevel() As Boolean
            Return _level >= _levelUpCosts.Count
        End Function

        ''' <summary>
        ''' レベルアップする。
        ''' </summary>
        ''' <remarks></remarks>
        Public Sub LevelUp()
            Debug.Assert(CanLevelUp())
            Money -= _levelUpCosts(_level)
            _level += 1
        End Sub

        ''' <summary>
        ''' 次のレベルにするために必要なコスト
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function NextLevelCost() As Integer
            Debug.Assert(Not IsMaxLevel())
            Return _levelUpCosts(_level)
        End Function

        ''' <summary>
        ''' 陣営から所持金のやり取りをする。
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Money As Integer
            Get
                Return _side.Money
            End Get
            Set(value As Integer)
                _side.Money = value
            End Set
        End Property
    End Class

End Namespace
