﻿Namespace Logic

    Public Class Side

        Private _platoonCostLists()() As Integer
        Private _platoonNameLists()() As String
        Private _platoonDetectLists()() As Integer
        Private _platoonInDirectDefenceLists()() As Integer
        Private _platoonDirectDefenceLists()() As Integer
        Private _platoonAttackLists()() As Integer
        Private _platoonRangeMaxLists()() As Integer
        Private _platoonRangeMinLists()() As Integer
        Private _platoonSpeedLists()() As Integer
        Private _platoonQuickLists()() As Integer

        ''' <summary>
        ''' 小隊の費用
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonCost(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonCostLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonCostLists(IntegerUnitType).Count)
            Return _platoonCostLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の名称
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonName(ByVal platoonUnit As PlatoonUnit) As String
            Debug.Assert(platoonUnit.UnitType < _platoonNameLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonNameLists(IntegerUnitType).Count)
            Return _platoonNameLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の索敵能力
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonDetect(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonDetectLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonDetectLists(IntegerUnitType).Count)
            Return _platoonDetectLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の間接防御
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonInDirectDefence(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonInDirectDefenceLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonInDirectDefenceLists(IntegerUnitType).Count)
            Return _platoonInDirectDefenceLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の直接防御
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonDirectDefence(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonDirectDefenceLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonDirectDefenceLists(IntegerUnitType).Count)
            Return _platoonDirectDefenceLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の攻撃力
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonAttack(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonAttackLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonAttackLists(IntegerUnitType).Count)
            Return _platoonAttackLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の最大射程範囲
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonRangeMax(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonRangeMaxLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonRangeMaxLists(IntegerUnitType).Count)
            Return _platoonRangeMaxLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の最低射程範囲
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonRangeMin(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonRangeMinLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonRangeMinLists(IntegerUnitType).Count)
            Return _platoonRangeMinLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の機動力
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonSpeed(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonSpeedLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonSpeedLists(IntegerUnitType).Count)
            Return _platoonSpeedLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        ''' <summary>
        ''' 小隊の素早さ
        ''' </summary>
        ''' <param name="platoonUnit"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function PlattonQuick(ByVal platoonUnit As PlatoonUnit) As Integer
            Debug.Assert(platoonUnit.UnitType < _platoonQuickLists.Count)
            Dim IntegerUnitType As Integer = DirectCast(platoonUnit.UnitType, Integer)
            Debug.Assert(platoonUnit.Level < _platoonQuickLists(IntegerUnitType).Count)
            Return _platoonQuickLists(IntegerUnitType)(platoonUnit.Level)
        End Function

        Private _sideName As String
        ''' <summary>
        ''' 軍名（帝国軍、自軍など）
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property Name As String
            Get
                Return _sideName
            End Get
        End Property

        Private _commanderName As String
        ''' <summary>
        ''' 指揮官名
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property CommanderName As String
            Get
                Return _commanderName
            End Get
        End Property

        Private Shared _player As Side = CreatePlayerSide()
        Public Shared Function GetPlayerSide() As Side
            Return _player
        End Function
        Private Shared _friend As Side = CreateFriendSide()
        Public Shared Function GetFriendSide() As Side
            Return _friend
        End Function
        Private Shared _enermy As Side = CreateEnermySide()
        Public Shared Function GetEnermy() As Side
            Return _enermy
        End Function

        Private Shared Function CreateFriendSide() As Side
            Dim friendSide As New Side
            friendSide._sideName = "友軍"
            friendSide._commanderName = "エンペドクレス"
            friendSide._platoonCostLists = {
                New Integer() {12, 25, 45, 70},
                New Integer() {12, 25, 45, 70},
                New Integer() {15, 30, 50, 80},
                New Integer() {15, 35, 55, 90},
                New Integer() {15, 35, 55, 90},
                New Integer() {10, 20, 40}}
            friendSide._platoonNameLists = {
                New String() {"軽歩兵", "正歩兵", "重歩兵", "機甲兵"},
                New String() {"長弓兵", "強弩兵", "長銃兵", "機銃兵"},
                New String() {"軽装騎兵", "重装騎兵", "機甲騎兵", "機甲戦車"},
                New String() {"マジシャン", "メイジ", "ビショップ", "ソーサラ"},
                New String() {"連弩", "回回砲", "高射砲", "榴弾砲"},
                New String() {"物見", "偵察軽騎", "高速騎兵"}}
            friendSide._platoonDetectLists = {
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {10, 10, 10}}
            friendSide._platoonInDirectDefenceLists = {
                New Integer() {2, 3, 4, 5},
                New Integer() {1, 2, 3, 4},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2}}
            friendSide._platoonDirectDefenceLists = {
                New Integer() {2, 3, 4, 5},
                New Integer() {1, 2, 3, 4},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2}}
            friendSide._platoonAttackLists = {
                New Integer() {2, 3, 4, 5},
                New Integer() {2, 3, 4, 5},
                New Integer() {4, 5, 6, 7},
                New Integer() {2, 3, 4, 5},
                New Integer() {3, 4, 5, 6},
                New Integer() {1, 1, 1}}
            friendSide._platoonRangeMaxLists = {
                New Integer() {1, 1, 1, 1},
                New Integer() {2, 3, 4, 5},
                New Integer() {1, 1, 1, 1},
                New Integer() {2, 2, 2, 2},
                New Integer() {3, 4, 5, 6},
                New Integer() {1, 1, 1}}
            friendSide._platoonRangeMinLists = {
                New Integer() {1, 1, 1, 1},
                New Integer() {1, 1, 1, 1},
                New Integer() {1, 1, 1, 1},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {1, 1, 1}}
            friendSide._platoonSpeedLists = {
                New Integer() {10, 10, 10, 10},
                New Integer() {13, 13, 13, 13},
                New Integer() {11, 11, 11, 11},
                New Integer() {9, 9, 9, 9},
                New Integer() {8, 8, 8, 8},
                New Integer() {17, 17, 17}}
            friendSide._platoonQuickLists = {
                New Integer() {12, 25, 45, 70},
                New Integer() {12, 25, 45, 70},
                New Integer() {15, 30, 50, 80},
                New Integer() {15, 35, 55, 90},
                New Integer() {15, 35, 55, 90},
                New Integer() {10, 20, 40}}

            Return friendSide
        End Function

        Private Shared Function CreatePlayerSide() As Side
            Dim playerside As New Side
            playerside._sideName = "自軍"
            playerside._commanderName = "ルジュール25世"
            playerside._platoonCostLists = {
                New Integer() {12, 25, 45, 70},
                New Integer() {12, 25, 45, 70},
                New Integer() {15, 30, 50, 80},
                New Integer() {15, 35, 55, 90},
                New Integer() {15, 35, 55, 90},
                New Integer() {10, 20, 40}}
            playerside._platoonNameLists = {
                New String() {"軽歩兵", "正歩兵", "重歩兵", "機甲兵"},
                New String() {"長弓兵", "強弩兵", "長銃兵", "機銃兵"},
                New String() {"軽装騎兵", "重装騎兵", "機甲騎兵", "機甲戦車"},
                New String() {"マジシャン", "メイジ", "ビショップ", "ソーサラ"},
                New String() {"連弩", "回回砲", "高射砲", "榴弾砲"},
                New String() {"物見", "偵察軽騎", "高速騎兵"}}
            playerside._platoonDetectLists = {
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {10, 10, 10}}
            playerside._platoonInDirectDefenceLists = {
                New Integer() {2, 3, 4, 5},
                New Integer() {1, 2, 3, 4},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2}}
            playerside._platoonDirectDefenceLists = {
                New Integer() {2, 3, 4, 5},
                New Integer() {1, 2, 3, 4},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2, 3},
                New Integer() {1, 1, 2}}
            playerside._platoonAttackLists = {
                New Integer() {2, 3, 4, 5},
                New Integer() {2, 3, 4, 5},
                New Integer() {4, 5, 6, 7},
                New Integer() {2, 3, 4, 5},
                New Integer() {3, 4, 5, 6},
                New Integer() {1, 1, 1}}
            playerside._platoonRangeMaxLists = {
                New Integer() {1, 1, 1, 1},
                New Integer() {2, 3, 4, 5},
                New Integer() {1, 1, 1, 1},
                New Integer() {2, 2, 2, 2},
                New Integer() {3, 4, 5, 6},
                New Integer() {1, 1, 1}}
            playerside._platoonRangeMinLists = {
                New Integer() {1, 1, 1, 1},
                New Integer() {1, 1, 1, 1},
                New Integer() {1, 1, 1, 1},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {1, 1, 1}}
            playerside._platoonSpeedLists = {
                New Integer() {9, 9, 9, 9},
                New Integer() {13, 13, 13, 13},
                New Integer() {10, 10, 10, 10},
                New Integer() {9, 9, 9, 9},
                New Integer() {8, 8, 8, 8},
                New Integer() {15, 15, 15}}
            playerside._platoonQuickLists = {
                New Integer() {12, 25, 45, 70},
                New Integer() {12, 25, 45, 70},
                New Integer() {15, 30, 50, 80},
                New Integer() {15, 35, 55, 90},
                New Integer() {15, 35, 55, 90},
                New Integer() {10, 20, 40}}

            Return playerside
        End Function

        Private Shared Function CreateEnermySide() As Side
            Dim enermyside As New Side
            enermyside._sideName = "帝国軍"
            enermyside._platoonCostLists = {
               New Integer() {12, 25, 45, 70, 100},
               New Integer() {12, 25, 45, 70, 100},
               New Integer() {15, 30, 50, 80, 110},
               New Integer() {15, 35, 55, 90, 120},
               New Integer() {15, 35, 55, 90, 120},
               New Integer() {10, 20, 40, 60, 90}}
            enermyside._platoonNameLists = {
                New String() {"準歩兵", "正規歩兵", "親衛歩兵", "特攻歩兵", "機械化歩兵"},
                New String() {"弓兵", "弩兵", "銃兵", "ライフル兵"},
                New String() {"騎兵", "騎馬戦車", "機甲騎兵", "機甲戦車"},
                New String() {"道化", "魔術師", "ビショップ", "ソーサラ"},
                New String() {"弩砲", "回回砲", "高射砲", "榴弾砲"},
                New String() {"物見", "偵察軽騎", "高速騎兵", "リンドバーグ"}}
            enermyside._platoonDetectLists = {
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {2, 2, 2, 2},
                New Integer() {10, 10, 10}}
            enermyside._platoonInDirectDefenceLists = {
                New Integer() {2, 3, 4, 5, 6},
                New Integer() {1, 2, 3, 4, 5},
                New Integer() {1, 1, 2, 3, 4},
                New Integer() {1, 1, 2, 3, 4},
                New Integer() {1, 1, 2, 3, 4},
                New Integer() {1, 1, 2, 2, 2}}
            enermyside._platoonDirectDefenceLists = {
                New Integer() {2, 3, 4, 5, 6},
                New Integer() {1, 2, 3, 4, 7},
                New Integer() {1, 1, 2, 3, 4},
                New Integer() {1, 1, 2, 3, 5},
                New Integer() {1, 1, 2, 3, 5},
                New Integer() {1, 1, 2, 3, 4}}
            enermyside._platoonAttackLists = {
                New Integer() {2, 3, 4, 5, 6},
                New Integer() {2, 3, 4, 5, 6},
                New Integer() {4, 5, 6, 7, 8},
                New Integer() {2, 3, 4, 5, 6},
                New Integer() {3, 4, 5, 6, 7},
                New Integer() {1, 1, 1, 1, 1}}
            enermyside._platoonRangeMaxLists = {
                New Integer() {1, 1, 1, 1, 1},
                New Integer() {2, 3, 4, 5, 6},
                New Integer() {1, 1, 1, 1, 1},
                New Integer() {2, 2, 2, 2, 2},
                New Integer() {3, 4, 5, 6, 7},
                New Integer() {1, 1, 1, 1, 1}}
            enermyside._platoonRangeMinLists = {
                New Integer() {1, 1, 1, 1, 1},
                New Integer() {1, 1, 1, 1, 1},
                New Integer() {1, 1, 1, 1, 1},
                New Integer() {2, 2, 2, 2, 2},
                New Integer() {2, 2, 2, 2, 2},
                New Integer() {1, 1, 1, 1, 1}}
            enermyside._platoonSpeedLists = {
                New Integer() {10, 10, 10, 10, 10},
                New Integer() {15, 15, 15, 15, 15},
                New Integer() {9, 9, 9, 9, 9},
                New Integer() {8, 8, 8, 8, 8},
                New Integer() {8, 8, 8, 8, 8},
                New Integer() {16, 16, 16, 16, 16}}
            enermyside._platoonQuickLists = {
                New Integer() {12, 25, 45, 70},
                New Integer() {12, 25, 45, 70},
                New Integer() {15, 30, 50, 80},
                New Integer() {15, 35, 55, 90},
                New Integer() {15, 35, 55, 90},
                New Integer() {10, 20, 40}}
            Return enermyside
        End Function

        Public Property Money As Integer
        Public Property Regiment As Regiment

        Public Property Range As SkillLevel = SkillLevel.GetRangeSkillLevel(Me)
        Public Property Quick As SkillLevel = SkillLevel.GetQuickSkillLevel(Me)
        Public Property Speed As SkillLevel = SkillLevel.GetSpeedSkillLevel(Me)
        Public Property Attack As SkillLevel = SkillLevel.GetAttackSkillLevel(Me)
        Public Property DirectDefence As SkillLevel = SkillLevel.GetDirectDefenceSkillLevel(Me)
        Public Property IndirectDefence As SkillLevel = SkillLevel.GetInDirectDefenceSkillLevel(Me)
        Public Property Detect As SkillLevel = SkillLevel.GetDetectSkillLevel(Me)


    End Class




End Namespace
