﻿Namespace Logic

    ''' <summary>
    ''' 連隊
    ''' </summary>
    ''' <remarks>
    ''' （自軍全隊）、(友軍）、（敵軍）を表す</remarks>
    Public Class Regiment

        Private _battalionUnits As New List(Of BattalionUnit)
        Public ReadOnly Property BattalionUnits() As IList(Of BattalionUnit)
            Get
                Return _battalionUnits
            End Get
        End Property

        Public Function CanAddUnit() As Boolean
            If 40 <= _battalionUnits.Count Then
                Return False
            End If
            Return True
        End Function

        Public Function CreateNewBattalionUnit() As BattalionUnit
            Debug.Assert(CanAddUnit())
            Dim bunit As New BattalionUnit(Me._side)
            bunit.Number = _battalionUnits.Count
            _battalionUnits.Add(bunit)
            Return bunit
        End Function

        Private _side As Side
        Public Sub New(side As Side)
            Me._side = side
            side.Regiment = Me
        End Sub


    End Class

End Namespace
