﻿Namespace Logic

    ''' <summary>
    ''' 小隊
    ''' </summary>
    ''' <remarks>
    ''' sideによって能力が決められる。</remarks>
    Public Class PlatoonUnitImpl
        Inherits PlatoonUnit

        Private _sideInstance As Side

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="side"></param>
        ''' <param name="unitType"></param>
        ''' <param name="level"></param>
        ''' <remarks></remarks>
        Public Sub New(ByVal side As Side, ByVal unitType As PlatoonUnit.UnitTypeEnum, ByVal level As Integer)
            Me._sideInstance = side
            Me.UnitType = unitType
            Me.Level = level
        End Sub

        ''' <summary>
        ''' コピーコンストラクタ
        ''' </summary>
        ''' <param name="source"></param>
        ''' <remarks></remarks>
        Public Sub New(ByVal source As PlatoonUnitImpl)
            MyBase.New(source)
            Me._sideInstance = source._sideInstance
        End Sub

        ''' <summary>
        ''' 値段をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetCost() As Integer
            Return _sideInstance.PlattonCost(Me)
        End Function

        ''' <summary>
        ''' 詳細部隊種名をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetName() As String
            Return _sideInstance.PlattonName(Me)
        End Function



        ''' <summary>
        ''' 索敵能力をSideから取得する。
        ''' </summary>
        ''' <remarks></remarks>
        Protected Overrides Function GetDetect() As Integer
            Return _sideInstance.PlattonDetect(Me) + _sideInstance.Detect.LevelValue
        End Function


        ''' <summary>
        ''' 間接防御力をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetInDirectDefence() As Integer
            Return _sideInstance.PlattonInDirectDefence(Me) + _sideInstance.IndirectDefence.LevelValue
        End Function


        ''' <summary>
        ''' 直接防御をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetDirectDefence() As Integer
            Return _sideInstance.PlattonDirectDefence(Me) + _sideInstance.DirectDefence.LevelValue
        End Function

        ''' <summary>
        ''' 攻撃力をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetAttack() As Integer
            Return _sideInstance.PlattonAttack(Me) + _sideInstance.Attack.LevelValue
        End Function


        ''' <summary>
        ''' 最大射程をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetRangeMax() As Integer
            Return _sideInstance.PlattonRangeMax(Me) + _sideInstance.Range.LevelValue
        End Function


        ''' <summary>
        ''' 最低射程をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks>
        ''' 術師や砲撃手は2となり近接攻撃ができない</remarks>
        Protected Overrides Function GetRangeMin() As Integer
            Return _sideInstance.PlattonRangeMin(Me)
        End Function


        ''' <summary>
        ''' 移動力をSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetSpeed() As Integer
            Return _sideInstance.PlattonSpeed(Me) + _sideInstance.Speed.LevelValue
        End Function

        ''' <summary>
        ''' 素早さをSideから取得する。
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Protected Overrides Function GetQuick() As Integer
            Return _sideInstance.PlattonQuick(Me) + _sideInstance.Quick.LevelValue
        End Function

    End Class
End Namespace

