﻿Namespace Logic

    ''' <summary>
    ''' 小隊
    ''' </summary>
    ''' <remarks>
    ''' 能力値は可変にできる。おもにテスト用で用いる。</remarks>
    Public Class PlatoonUnit

        Enum UnitTypeEnum
            ''' <summary>
            ''' 歩兵
            ''' </summary>
            ''' <remarks></remarks>
            Infantry
            ''' <summary>
            ''' 弓兵
            ''' </summary>
            ''' <remarks></remarks>
            Archer
            ''' <summary>
            ''' 騎士
            ''' </summary>
            ''' <remarks></remarks>
            Knight
            ''' <summary>
            ''' 術師
            ''' </summary>
            ''' <remarks></remarks>
            Magician
            ''' <summary>
            ''' 砲兵
            ''' </summary>
            ''' <remarks></remarks>
            Artillery
            ''' <summary>
            ''' 偵察兵
            ''' </summary>
            ''' <remarks></remarks>
            Patrol
        End Enum

        Private _unitTypeNames As String() = {"歩", "弓", "騎", "術", "砲", "偵"}
        ''' <summary>
        ''' 兵種名称
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property UnitTypeName() As String
            Get
                Return _unitTypeNames(UnitType)
            End Get
        End Property

        Public Sub New()
        End Sub

        ''' <summary>
        ''' 所属大隊
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Battalion As BattalionUnit

        ''' <summary>
        ''' 小隊番号
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Number As Integer

        ''' <summary>
        ''' コピーコンストラクタ
        ''' </summary>
        ''' <param name="source"></param>
        ''' <remarks></remarks>
        Public Sub New(ByVal source As PlatoonUnit)
            Me.Battalion = source.Battalion
            Me.UnitType = source.UnitType
            Me._hp = source._hp
            Me.Level = source.Level
            Me.Name = source.Name
            Me.Cost = source.Cost
            Me.Detect = source.Detect
            Me.DirectDefence = source.DirectDefence
            Me.InDirectDefence = source.InDirectDefence
            Me.Quick = source.Quick
            Me.Attack = source.Attack
            Me.RangeMax = source.RangeMax
            Me.RangeMin = source.RangeMin
            Me.Speed = source.Speed
        End Sub

        Private _cost As Integer
        ''' <summary>
        ''' 値段
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Cost As Integer
            Get
                If IsEmpty Then
                    Return 0
                End If
                Return GetCost()
            End Get
            Set(value As Integer)
                _cost = value
            End Set
        End Property
        Protected Overridable Function GetCost() As Integer
            Return _cost
        End Function


        Private _name As String
        ''' <summary>
        ''' 詳細部隊種名
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Name As String
            Get
                Return GetName()
            End Get
            Set(value As String)
                _name = value
            End Set
        End Property
        Protected Overridable Function GetName() As String
            Return _name
        End Function

        ''' <summary>
        ''' 部隊レベル
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Level As Integer

        ''' <summary>
        ''' ユニットタイプ
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property UnitType As UnitTypeEnum

        ''' <summary>
        ''' 混乱しているか
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property IsConfused As Boolean

        Private _hp As Integer = 20
        ''' <summary>
        ''' 人数
        ''' </summary>
        ''' <remarks></remarks>
        Public Property Hp As Integer
            Get
                Return _hp
            End Get
            Set(value As Integer)
                If value <= _hp \ 2 Then
                    IsConfused = True
                End If
                _hp = value
                If Battalion IsNot Nothing Then
                    Battalion.RemoveWithDamage()
                End If
            End Set
        End Property

        ''' <summary>
        ''' 部隊が消えているかどうか
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property IsEmpty As Boolean
            Get
                Return Hp <= 0
            End Get
        End Property

        Private _detect As Integer
        ''' <summary>
        ''' 索敵能力
        ''' </summary>
        ''' <remarks></remarks>
        Public Property Detect As Integer
            Get
                Return GetDetect()
            End Get
            Set(value As Integer)
                _detect = value
            End Set
        End Property
        Protected Overridable Function GetDetect() As Integer
            Return _detect
        End Function

        Private _InDirectDefence As Integer
        ''' <summary>
        ''' 間接防御力
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property InDirectDefence As Integer
            Get
                Return GetInDirectDefence()
            End Get
            Set(value As Integer)
                _InDirectDefence = value
            End Set
        End Property
        Protected Overridable Function GetInDirectDefence() As Integer
            Return _InDirectDefence
        End Function

        Private _DirectDefence As Integer
        ''' <summary>
        ''' 直接防御
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property DirectDefence As Integer
            Get
                Return GetDirectDefence()
            End Get
            Set(value As Integer)
                _DirectDefence = value
            End Set
        End Property
        Protected Overridable Function GetDirectDefence() As Integer
            Return _DirectDefence
        End Function

        Private _Attack As Integer
        ''' <summary>
        ''' 攻撃力
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Attack As Integer
            Get
                Return GetAttack()
            End Get
            Set(value As Integer)
                _Attack = value
            End Set
        End Property
        Protected Overridable Function GetAttack() As Integer
            Return _Attack
        End Function

        Private _RangeMax As Integer
        ''' <summary>
        ''' 最大射程
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property RangeMax As Integer
            Get
                Return GetRangeMax()
            End Get
            Set(value As Integer)
                _RangeMax = value
            End Set
        End Property
        Protected Overridable Function GetRangeMax() As Integer
            Return _RangeMax
        End Function

        Private _RangeMin As Integer
        ''' <summary>
        ''' 最低射程
        ''' </summary>
        ''' <value>1～2</value>
        ''' <returns></returns>
        ''' <remarks>
        ''' 術師や砲撃手は2となり近接攻撃ができない</remarks>
        Public Property RangeMin As Integer
            Get
                Return GetRangeMin()
            End Get
            Set(value As Integer)
                _RangeMin = value
            End Set
        End Property
        Protected Overridable Function GetRangeMin() As Integer
            Return _RangeMin
        End Function

        Private _Speed As Integer
        ''' <summary>
        ''' 移動力(機動力）
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Speed As Integer
            Get
                Return GetSpeed()
            End Get
            Set(value As Integer)
                _Speed = value
            End Set
        End Property
        Protected Overridable Function GetSpeed() As Integer
            Return _Speed
        End Function

        Private _Quick As Integer
        ''' <summary>
        ''' 素早さ
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Quick As Integer
            Get
                Return GetQuick()
            End Get
            Set(value As Integer)
                _Quick = value
            End Set
        End Property
        Protected Overridable Function GetQuick() As Integer
            Return _Quick
        End Function

    End Class
End Namespace

