﻿Namespace Logic
    Public Class Cell

        Private _unit As BattalionUnit
        Public Property Unit As BattalionUnit
            Get
                Return _unit
            End Get
            Set(value As BattalionUnit)
                If value IsNot Nothing Then
                    Debug.Assert(UnitIsNotExist)
                End If
                _unit = value
            End Set
        End Property

        Public Function UnitIsNotExist() As Boolean
            Return _unit Is Nothing
        End Function

        Public Property FieldInstance As Field = Logic.Field.GetFieldInstance(Logic.Field.TypeEnum.UNKNOWN)

        Public ReadOnly Property FieldMovePoint() As Integer
            Get
                Return Field.GetFieldMovePoint(FieldInstance.Type)
            End Get
        End Property

        Private _x As Integer
        Public ReadOnly Property X As Integer
            Get
                Return _x
            End Get
        End Property

        Private _y As Integer
        Public ReadOnly Property Y As Integer
            Get
                Return _y
            End Get
        End Property

        Public Sub New(ByVal x As Integer, ByVal y As Integer)
            Me._x = x
            Me._y = y
        End Sub

    End Class

End Namespace
