﻿Namespace Logic

    ''' <summary>
    ''' 大隊
    ''' </summary>
    ''' <remarks></remarks>
    Public Class BattalionUnit

        Public Property Side As Side
        Private _map As Hexmap

        ''' <summary>
        ''' 部隊番号
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Property Number As Integer

        ''' <summary>
        ''' 部隊名称
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property Name As String
            Get
                Return String.Format("{0} 第{1}部隊", Side.Name, Number)
            End Get
        End Property

        Public ReadOnly Property IsConfused As Boolean
            Get
                Dim confusedUnitCount As Integer = 0
                For Each punit As PlatoonUnit In PlattonUnits
                    If Not punit.IsEmpty AndAlso
                        punit.IsConfused Then
                        confusedUnitCount += 1
                    End If
                Next
                If confusedUnitCount * 2 >= PlattonUnits.Count Then
                    Return True
                End If
                Return False
            End Get
        End Property
        Public Sub New(ByVal side As Side)
            Me.Side = side
        End Sub
        Private Sub New()
        End Sub

        ''' <summary>
        ''' 大隊を移動させる。
        ''' </summary>
        ''' <param name="toX"></param>
        ''' <param name="toY"></param>
        ''' <remarks></remarks>
        Public Sub MoveTo(ByVal toX As Integer, ByVal toY As Integer)
            Debug.Assert(_map IsNot Nothing)
            _fromX = _x
            _fromY = _y
            Dim FromCell As Cell = _map.Cell(_fromX, _fromY)
            FromCell.Unit = Nothing
            Dim ToCell As Cell = _map.Cell(toX, toY)
            ToCell.Unit = Me
            _x = toX
            _y = toY
        End Sub

        ''' <summary>
        ''' 大隊をマップ上から消す。
        ''' </summary>
        ''' <remarks></remarks>
        Public Sub RemoveFromMap()
            Debug.Assert(_map IsNot Nothing)
            Dim FromCell As Cell = _map.Cell(_x, _y)
            FromCell.Unit = Nothing
        End Sub

        ''' <summary>
        ''' ダメージを受けた後処理
        ''' </summary>
        ''' <remarks></remarks>
        Friend Sub RemoveWithDamage()
            If IsEmpty Then
                If _map IsNot Nothing Then
                    RemoveFromMap()
                End If
            End If
        End Sub

        ''' <summary>
        ''' ユニットが存在しない
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property IsEmpty() As Boolean
            Get
                Dim isAllNull As Boolean = True
                For Each p As PlatoonUnit In _platoonUnits
                    If Not p.IsEmpty Then
                        isAllNull = False
                        Exit For
                    End If
                Next
                Return isAllNull
            End Get
        End Property

        ''' <summary>
        ''' 大隊を戦場に配置する
        ''' </summary>
        ''' <param name="map"></param>
        ''' <param name="x"></param>
        ''' <param name="y"></param>
        ''' <remarks></remarks>
        Public Sub SetTo(ByVal map As Hexmap, ByVal x As Integer, ByVal y As Integer)
            _map = map
            _x = x
            _y = y
            _fromX = x
            _fromY = x
            Dim ToCell As Cell = map.Cell(x, y)
            ToCell.Unit = Me
        End Sub


        ''' <summary>
        ''' 大隊コスト（小隊のトータル）
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property Cost As Integer
            Get
                Dim sum As Integer = 0
                For Each punit As PlatoonUnit In _platoonUnits
                    sum += punit.Cost
                Next
                Return sum
            End Get
        End Property

        ''' <summary>
        ''' 大隊の機動力（小隊の平均）
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property Speed As Integer
            Get
                Debug.Assert(1 <= _platoonUnits.Count)
                Dim sum As Integer = 0
                For Each punit As PlatoonUnit In _platoonUnits
                    sum += punit.Speed
                Next
                Return CInt(Math.Ceiling(sum / _platoonUnits.Count))
            End Get
        End Property

        Private _x As Integer
        ''' <summary>
        ''' マップ上の横位置
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property x As Integer
            Get
                Return _x
            End Get
        End Property

        Private _y As Integer
        ''' <summary>
        ''' マップ上の縦位置
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property y As Integer
            Get
                Return _y
            End Get
        End Property

        Private _fromX As Integer
        ''' <summary>
        ''' 移動元の横位置
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property FromX As Integer
            Get
                Return _fromX
            End Get
        End Property

        Private _fromY As Integer
        ''' <summary>
        ''' 移動元の縦位置
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property FromY As Integer
            Get
                Return _fromY
            End Get
        End Property

        Private _platoonUnits As New List(Of PlatoonUnit)
        ''' <summary>
        ''' 小隊の集合
        ''' </summary>
        ''' <value></value>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public ReadOnly Property PlattonUnits() As IList(Of PlatoonUnit)
            Get
                Return _platoonUnits
            End Get
        End Property

        ''' <summary>
        ''' 小隊をすべてクリアする。
        ''' </summary>
        ''' <remarks></remarks>
        Public Sub UnitClear()
            Side.Money += Cost
            _platoonUnits.Clear()
        End Sub

        ''' <summary>
        ''' 小隊が追加できるか
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function CanAddUnit() As Boolean
            If MaxUnitCount() <= _platoonUnits.Count Then
                Return False
            End If
            Return True
        End Function

        Public Function MaxUnitCount() As Integer
            Return 5
        End Function

        ''' <summary>
        ''' 小隊を追加する。
        ''' </summary>
        ''' <param name="unit"></param>
        ''' <remarks></remarks>
        Public Sub AddPlatoonUnit(ByVal unit As PlatoonUnit)
            Debug.Assert(CanAddUnit())
            unit.Number = _platoonUnits.Count
            _platoonUnits.Add(unit)
            Me.Side.Money -= unit.Cost
        End Sub

        ''' <summary>
        ''' 攻撃範囲
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function RangeString() As String
            Debug.Assert(1 <= _platoonUnits.Count)
            Dim min As Integer = RangeMin()
            Dim max As Integer = RangeMax()
            If min = max Then
                Return String.Format("{0}", max)
            End If
            Return String.Format("{0}‐{1}", min, max)
        End Function

        ''' <summary>
        ''' 最低射程距離
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function RangeMin() As Integer
            Debug.Assert(1 <= _platoonUnits.Count)
            Dim range As Integer = _platoonUnits(0).RangeMin
            For i As Integer = 1 To _platoonUnits.Count - 1
                Dim punit As PlatoonUnit = _platoonUnits(i)
                If range > punit.RangeMin Then
                    range = punit.RangeMin
                End If
            Next
            Return range
        End Function

        ''' <summary>
        ''' 最高射程距離
        ''' </summary>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function RangeMax() As Integer
            Debug.Assert(1 <= _platoonUnits.Count)
            Dim range As Integer = _platoonUnits(0).RangeMax
            For i As Integer = 1 To _platoonUnits.Count - 1
                Dim punit As PlatoonUnit = _platoonUnits(i)
                If range < punit.RangeMax Then
                    range = punit.RangeMax
                End If
            Next
            Return range
        End Function

    End Class

End Namespace
