﻿Imports System.Text
Imports Microsoft.VisualStudio.TestTools.UnitTesting
Namespace Logic
    <TestClass()> Public Class PlatoonUnitTest

        <TestMethod()> Public Sub PropertyTest()
            Dim unit As New PlatoonUnit
            unit.UnitType = PlatoonUnit.UnitTypeEnum.Magician
            unit.Level = 3
            unit.Name = "鬼術師"
            Assert.AreEqual(False, unit.IsEmpty)
            Assert.AreEqual("鬼術師", unit.Name)
            Assert.AreEqual(PlatoonUnit.UnitTypeEnum.Magician, unit.UnitType)
            Assert.AreEqual("術", unit.UnitTypeName)
            Assert.AreEqual(3, unit.Level)
            Assert.AreEqual(20, unit.Hp)
            Assert.AreEqual(0, unit.Cost)
        End Sub

        <TestMethod()> Public Sub Property2Test()
            Dim unit As New PlatoonUnit
            unit.UnitType = PlatoonUnit.UnitTypeEnum.Knight
            unit.Level = 3
            unit.Name = "重装騎兵"
            unit.Cost = 90
            unit.Detect = 5
            unit.DirectDefence = 3
            unit.InDirectDefence = 4
            unit.Quick = 10
            unit.Attack = 9
            unit.RangeMax = 1
            unit.RangeMin = 1
            unit.Speed = 15
            Assert.AreEqual(False, unit.IsEmpty)
            Assert.AreEqual("重装騎兵", unit.Name)
            Assert.AreEqual(PlatoonUnit.UnitTypeEnum.Knight, unit.UnitType)
            Assert.AreEqual("騎", unit.UnitTypeName)
            Assert.AreEqual(3, unit.Level)
            Assert.AreEqual(20, unit.Hp)
            Assert.AreEqual(90, unit.Cost)
            Assert.AreEqual(5, unit.Detect)
            Assert.AreEqual(3, unit.DirectDefence)
            Assert.AreEqual(4, unit.InDirectDefence)
            Assert.AreEqual(10, unit.Quick)
            Assert.AreEqual(9, unit.Attack)
            Assert.AreEqual(1, unit.RangeMax)
            Assert.AreEqual(1, unit.RangeMin)
            Assert.AreEqual(15, unit.Speed)
        End Sub


        <TestMethod()> Public Sub NewTest()
            Dim sourceUnit As New PlatoonUnit
            sourceUnit.UnitType = PlatoonUnit.UnitTypeEnum.Knight
            sourceUnit.Level = 3
            sourceUnit.Name = "重装騎兵"
            sourceUnit.Cost = 90
            sourceUnit.Detect = 5
            sourceUnit.DirectDefence = 3
            sourceUnit.InDirectDefence = 4
            sourceUnit.Quick = 10
            sourceUnit.Attack = 9
            sourceUnit.RangeMax = 1
            sourceUnit.RangeMin = 1
            sourceUnit.Speed = 15
            Dim unit As New PlatoonUnit(sourceUnit)
            Assert.AreEqual(False, unit.IsEmpty)
            Assert.AreEqual("重装騎兵", unit.Name)
            Assert.AreEqual(PlatoonUnit.UnitTypeEnum.Knight, unit.UnitType)
            Assert.AreEqual("騎", unit.UnitTypeName)
            Assert.AreEqual(3, unit.Level)
            Assert.AreEqual(20, unit.Hp)
            Assert.AreEqual(90, unit.Cost)
            Assert.AreEqual(5, unit.Detect)
            Assert.AreEqual(3, unit.DirectDefence)
            Assert.AreEqual(4, unit.InDirectDefence)
            Assert.AreEqual(10, unit.Quick)
            Assert.AreEqual(9, unit.Attack)
            Assert.AreEqual(1, unit.RangeMax)
            Assert.AreEqual(1, unit.RangeMin)
            Assert.AreEqual(15, unit.Speed)
        End Sub



        <TestMethod()> Public Sub PlattonIsEmpty1Test()
            Dim unit As New PlatoonUnit
            Assert.AreEqual(False, unit.IsEmpty)
            Assert.AreEqual(20, unit.Hp)
            unit.Hp -= 19
            Assert.AreEqual(False, unit.IsEmpty)
            unit.Hp -= 1
            Assert.AreEqual(True, unit.IsEmpty)
            unit.Hp -= 5
            Assert.AreEqual(True, unit.IsEmpty)
        End Sub
        <TestMethod()> Public Sub PlattonIsEmpty2Test()
            Dim unit As New PlatoonUnit
            Assert.AreEqual(False, unit.IsEmpty)
            unit.Hp -= 21
            Assert.AreEqual(True, unit.IsEmpty)
        End Sub

        <TestMethod()> Public Sub IsConfusedTest()
            Dim unit As New PlatoonUnit
            Assert.AreEqual(False, unit.IsConfused)
            unit.Hp -= 10
            Assert.AreEqual(True, unit.IsConfused)
        End Sub

        <TestMethod()> Public Sub IsConfused2Test()
            Dim unit As New PlatoonUnit
            Assert.AreEqual(False, unit.IsConfused)
            unit.Hp -= 8
            Assert.AreEqual(False, unit.IsConfused)
            unit.Hp -= 4
            Assert.AreEqual(False, unit.IsConfused)
            unit.Hp -= 4
            Assert.AreEqual(True, unit.IsConfused)
        End Sub
    End Class
End Namespace
