/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		sil.h̃vZbTˑiRX600V[Ypj
 */

#ifndef TOPPERS_PRC_SIL_H
#define TOPPERS_PRC_SIL_H


#ifndef TOPPERS_MACRO_ONLY
#include "prc_insn.h"


/*
 *  S݋֎~
 */
Inline uint32_t
TOPPERS_disint( void )
{
	volatile uint32_t	TOPPERS_psw;

	TOPPERS_psw = current_psw();
	disint();

	return( TOPPERS_psw );
}


/*
 *  S݋
 */
Inline void
TOPPERS_enaint( uint32_t TOPPERS_psw )
{
	if( TOPPERS_psw & PSW_I_MASK ){
		enaint();
	}
}


/*
 *  S݃bNԂ̐
 */
#define SIL_PRE_LOC		uint32_t TOPPERS_i_psw;
#define SIL_LOC_INT()	( ( void )( TOPPERS_i_psw = TOPPERS_disint() ) )
#define SIL_UNL_INT()	( TOPPERS_enaint( TOPPERS_i_psw ) )


/*
 *  GfBA̔]
 *
 *  {Jł̓GfBAϊ߂݂邽,
 *  A[LeN`ˑɂă}N㏑.
 */
#define TOPPERS_SIL_REV_ENDIAN_UINT16( data )	\
 								rev_endian_uint16( data )
#define TOPPERS_SIL_REV_ENDIAN_UINT32( data )	\
 								rev_endian_uint32( data )


/*
 *  ԑ҂
 */
extern void sil_dly_nse( ulong_t dlytim );

#endif /* TOPPERS_MACRO_ONLY */


/*
 *  vZbT̃GfBA
 */
#define SIL_ENDIAN_LITTLE			/* gGfBA */


#endif /* TOPPERS_PRC_SIL_H */
