/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *		vZbT̓ꖽ߂̃CC֐`iRX600V[Ypj
 */

#ifndef	TOPPERS_PRC_INSN_H
#define	TOPPERS_PRC_INSN_H


static uint32_t current_psw( void );
static void set_psw( uint32_t psw );
Inline uint32_t current_ipl( void );
Inline void set_ipl( uint32_t ipl );
static void disint( void );
static void enaint( void );
static uint16_t rev_endian_uint16( uint16_t data );
static uint32_t rev_endian_uint32( uint32_t data );


/*
 *  ItO, IPL擾邽߂̃}N`
 */
#define PSW_I_MASK		( 0x00010000UL )
#define PSW_IPL_MASK	( 0x07000000UL )


/*
 *  vZbTXe[^XWX^(PSW)̌ݒl̓Ǐo
 */
#pragma inline_asm	current_psw
static uint32_t
current_psw( void )
{
	mvfc	psw, r1
}


/*
 *  vZbTXe[^XWX^(PSW)֐ݒ
 */
#pragma inline_asm	set_psw
static void
set_psw( uint32_t psw )
{
	mvtc	r1, psw
}


/*
 *  IPĽݒl̓Ǐo
 */
Inline uint32_t
current_ipl( void )
{
	return ( uint32_t )( current_psw() & PSW_IPL_MASK );
}


/*
 *  IPL֐ݒ
 */
Inline void
set_ipl( uint32_t ipl )
{
	set_psw( ( current_psw() & ( ~PSW_IPL_MASK ) ) | ipl );
}


/*
 *  NMIׂĂ݂̊̋֎~
 */
#pragma inline_asm	disint
static void
disint( void )
{
	clrpsw	i
}


/*
 *  NMIׂĂ݂̊̋
 */
#pragma inline_asm	enaint
static void
enaint( void )
{
	setpsw	i
}


/*
 *  GfBAϊ 16bit
 */
#pragma inline_asm	rev_endian_uint16
static uint16_t
rev_endian_uint16( uint16_t data )
{
	revw	r1, r1
}

/*
 *  GfBAϊ 32bit
 */
#pragma inline_asm	rev_endian_uint32
static uint32_t
rev_endian_uint32( uint32_t data )
{
	revl	r1, r1
}


#endif /* TOPPERS_PRC_INSN_H */
