//==============================================================================
//
// Title:       lviconvwrapper
// Purpose:     A short description of the library.
//
// libiconv.dll : http://jaist.dl.sourceforge.net/project/gnuwin32/libiconv/1.9.2-1/libiconv-1.9.2-1-bin.zip
// libiconv.lib : http://jaist.dl.sourceforge.net/project/gnuwin32/libiconv/1.9.2-1/libiconv-1.9.2-1-lib.zip
//
//==============================================================================

//==============================================================================
// Include files

#include <windows.h>

#include "iconv.h"

#include "lviconvwrapper.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

//==============================================================================
// Global functions

// HIFN  What does your function do?
// HIPAR x/What inputs does your function expect?
// HIRET What does your function return?
int UTF8toSJIS(unsigned char *utf8str, int utf8strlen, unsigned char *sjisstr, int sjisstrlen)
{
   char const *pin;
   char *pout;
   iconv_t cd;
   size_t ilen, rlen;

   if  (utf8str == NULL || sjisstr == NULL) {
	   return -1;
   }

   cd = iconv_open("SJIS", "UTF-8");
   if(cd == (iconv_t)-1){
      // perror("iconv open");
      return -1;
   }

   ilen = strlen(utf8str);
   rlen = sjisstrlen - 1;
   if (ilen > rlen) {
      // perror("iconv");
	   return -1;
   }
   pin  = utf8str; // important!! 
   pout = sjisstr; // important!!

   rlen = iconv(cd, &pin, &ilen, &pout, &rlen);
   if (rlen == -1) {
      // perror("iconv");
      return -1;
   }
   *pout = '\0'; // important!!
   iconv_close(cd);

    return 0;
}

int SJIStoUTF8(unsigned char *sjisstr, int sjisstrlen, unsigned char *utf8str, int utf8strlen)
{
   char const *pin;
   char *pout;
   iconv_t cd;
   size_t ilen, rlen;

   if  (utf8str == NULL || sjisstr == NULL) {
	   return -1;
   }

   cd = iconv_open("UTF-8", "SJIS");
   if(cd == (iconv_t)-1){
      // perror("iconv open");
      return -1;
   }

   ilen = strlen(sjisstr);
   rlen = utf8strlen - 1;
   if (ilen > rlen) {
      // perror("iconv");
	   return -1;
   }
   pin  = sjisstr; // important!! 
   pout = utf8str; // important!!

   rlen = iconv(cd, &pin, &ilen, &pout, &rlen);
   if (rlen == -1) {
      // perror("iconv");
      return -1;
   }
   *pout = '\0'; // important!!
   iconv_close(cd);

    return 0;
}

//==============================================================================
// DLL main entry-point functions

int __stdcall DllMain (HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
    switch (fdwReason) {
        case DLL_PROCESS_ATTACH:
            break;
        case DLL_PROCESS_DETACH:
            break;
    }
    
    return 1;
}

int __stdcall DllEntryPoint (HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
    /* Included for compatibility with Borland */

    return DllMain (hinstDLL, fdwReason, lpvReserved);
}

