#ifndef DAQTHREAD_H
#define DAQTHREAD_H

#include <QThread>
#include <QDateTime>

#include "logthread.h"

class DAQThread : public QThread
{
    Q_OBJECT
public:
    explicit DAQThread(QObject *parent = 0);
    ~DAQThread();
    void stop();

signals:
    void LogStart(QString logfolderpath);
    void LogStop();
    void GetData(QDateTime timestamp, double tmpr, double humid);
    void ChangeLogFilename(QString filename);
    void LogStarted();
    void LogEnded(int status); // status 0 is success, !0 is Fail

public slots:
    void slotLogStarted();
    void slotLogEnded(int status); // status 0 is success, !0 is Fail

protected:
    void run();

private:
    volatile bool stopped;

    bool logging; // log status, true is logging

    LogThread *logTh;
};

#endif // DAQTHREAD_H
