
#ifndef __USBRH_H__
#define __USBRH_H__

#if __LIBUSB_WIN32__
#include "lusb0_usb.h"
#else
#include <usb.h>
#endif

class usbrh
{

private:
    double convert_temp(int in);
    double convert_humidity(int in);
    struct usb_device *searchdevice(unsigned int vendor, unsigned int product, int num);
    struct usb_device *listdevice(unsigned int vendor, unsigned int product);

    struct usb_device *gDevice;
    usb_dev_handle *gDevHandle;

public:
    usbrh();
    ~usbrh();

    int open();
    int config();
    int get_tempr_humid(double *tempr, double *humid);
    void close();

};

#endif /* __USBRH_H__ */
